/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 *  net.minecraft.class_1297
 *  net.minecraft.class_1309
 *  org.jetbrains.annotations.ApiStatus$Internal
 *  org.jetbrains.annotations.Nullable
 */
package moscow.rockstar.utility.rotations;

import moscow.rockstar.Rockstar;
import moscow.rockstar.utility.interfaces.IMinecraft;
import moscow.rockstar.utility.math.MathUtility;
import moscow.rockstar.utility.rotations.MoveCorrection;
import moscow.rockstar.utility.rotations.Rotation;
import moscow.rockstar.utility.rotations.RotationMath;
import moscow.rockstar.utility.rotations.RotationPriority;
import moscow.rockstar.utility.rotations.RotationState;
import moscow.rockstar.utility.rotations.RotationTask;
import moscow.rockstar.utility.rotations.RotationUpdateListener;
import moscow.rockstar.utility.time.Timer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class RotationHandler
implements IMinecraft {
    private final RotationUpdateListener rotationUpdateListener;
    private Rotation currentRotation = Rotation.ZERO;
    private final Rotation serverRotation = Rotation.ZERO;
    private Rotation prevRotation = Rotation.ZERO;
    private Rotation renderRotation = Rotation.ZERO;
    private RotationState state = RotationState.IDLE;
    @Nullable
    private RotationTask currentTask;
    private final Timer rotationIdle = new Timer();

    public RotationHandler(RotationUpdateListener rotationUpdateListener) {
        this.rotationUpdateListener = rotationUpdateListener;
        Rockstar.getInstance().getEventManager().subscribe(this);
    }

    public boolean isIdling() {
        return this.state == RotationState.IDLE;
    }

    @ApiStatus.Internal
    public void update() {
        this.prevRotation = this.currentRotation;
        if (this.currentTask == null) {
            this.currentRotation = this.getPlayerRotation();
            return;
        }
        if (this.rotationIdle.finished(70L)) {
            if (this.getPlayerRotation().differenceValue(this.currentRotation) < 1.0f) {
                this.state = RotationState.IDLE;
                this.currentTask = null;
            } else {
                this.state = RotationState.ROTATING_BACK;
                RotationHandler.mc.field_1724.method_36456(RotationMath.adjustAngle(this.currentRotation.getYaw(), RotationHandler.mc.field_1724.method_36454()));
                this.currentRotation = RotationMath.correctRotation(new Rotation(this.moveTowardsAngle(this.currentRotation.getYaw(), this.getPlayerRotation().getYaw(), this.currentTask.getReturnSpeed()), this.moveTowardsAngle(this.currentRotation.getPitch(), this.getPlayerRotation().getPitch(), this.currentTask.getReturnSpeed())));
            }
            return;
        }
        this.state = RotationState.ROTATING;
        this.currentRotation = RotationMath.correctRotation(new Rotation(this.moveTowardsAngle(this.currentRotation.getYaw(), this.currentTask.getRotation().getYaw(), this.currentTask.getSpeedX()), this.moveTowardsAngle(this.currentRotation.getPitch(), this.currentTask.getRotation().getPitch(), this.currentTask.getSpeedY())));
    }

    public void updateRender(float partialTicks) {
        if (RotationHandler.mc.field_1724 == null) {
            return;
        }
        float yaw = MathUtility.interpolate(this.prevRotation.getYaw(), this.currentRotation.getYaw(), partialTicks);
        float pitch = this.prevRotation.getPitch() + (this.currentRotation.getPitch() - this.prevRotation.getPitch()) * partialTicks;
        if (pitch <= -85.0f) {
            pitch = 0.0f;
        }
        this.renderRotation = new Rotation(yaw, pitch);
        if (Rockstar.getInstance().getTargetManager().getCurrentTarget() != null) {
            // empty if block
        }
    }

    public void rotate(Rotation rotation, MoveCorrection moveCorrection, float yawSpeed, float pitchSpeed, float returnSpeed, RotationPriority priority) {
        int priorityValue = priority.getPriority();
        if (this.currentTask == null || this.currentTask.getPriority() <= priorityValue || this.state != RotationState.ROTATING) {
            rotation.setYaw(RotationMath.adjustAngle(this.currentTask == null ? this.getPlayerRotation().getYaw() : this.currentTask.getRotation().getYaw(), rotation.getYaw()));
            this.currentTask = new RotationTask(rotation, moveCorrection, yawSpeed, pitchSpeed, returnSpeed, priorityValue);
            this.rotationIdle.reset();
        }
    }

    public void rotate(Rotation rotation, MoveCorrection moveCorrection, float yawSpeed, float pitchSpeed, float returnSpeed) {
        this.rotate(rotation, moveCorrection, yawSpeed, pitchSpeed, returnSpeed, RotationPriority.NORMAL);
    }

    public void rotate(Rotation rotation, RotationPriority priority) {
        this.rotate(rotation, MoveCorrection.DIRECT, 180.0f, 180.0f, 180.0f, priority);
    }

    public void rotate(Rotation rotation) {
        this.rotate(rotation, MoveCorrection.DIRECT, 180.0f, 180.0f, 180.0f, RotationPriority.NORMAL);
    }

    private float moveTowardsAngle(float current, float target, float speed) {
        float difference = RotationMath.getAngleDifference(current, target);
        if (Math.abs(difference) <= speed) {
            return target;
        }
        return current + Math.signum(difference) * speed;
    }

    public void rotateTowards(class_1297 entity, long yawSpeed, long pitchSpeed, long returnSpeed, RotationPriority priority, MoveCorrection moveCorrection) {
        if (entity == null || RotationHandler.mc.field_1724 == null) {
            return;
        }
        double posX = entity.method_23317();
        double posY = entity.method_23318() + (double)entity.method_18381(entity.method_18376());
        double posZ = entity.method_23321();
        double deltaX = posX - RotationHandler.mc.field_1724.method_23317();
        double deltaY = posY - (RotationHandler.mc.field_1724.method_23318() + (double)RotationHandler.mc.field_1724.method_18381(RotationHandler.mc.field_1724.method_18376()));
        double deltaZ = posZ - RotationHandler.mc.field_1724.method_23321();
        double horizontalDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        float yaw = (float)Math.toDegrees(Math.atan2(deltaZ, deltaX)) - 90.0f;
        float pitch = (float)(-Math.toDegrees(Math.atan2(deltaY, horizontalDistance)));
        Rotation targetRotation = new Rotation(yaw, pitch);
        this.rotate(targetRotation, moveCorrection, yawSpeed, pitchSpeed, returnSpeed, priority);
    }

    public Rotation getRotation(class_1309 entity) {
        return new Rotation(entity.method_36454(), entity.method_36455());
    }

    public Rotation getPlayerRotation() {
        if (RotationHandler.mc.field_1724 == null) {
            return Rotation.ZERO;
        }
        return this.getRotation((class_1309)RotationHandler.mc.field_1724);
    }

    public RotationUpdateListener getRotationUpdateListener() {
        return this.rotationUpdateListener;
    }

    public Rotation getCurrentRotation() {
        return this.currentRotation;
    }

    public Rotation getServerRotation() {
        return this.serverRotation;
    }

    public Rotation getPrevRotation() {
        return this.prevRotation;
    }

    public Rotation getRenderRotation() {
        return this.renderRotation;
    }

    public RotationState getState() {
        return this.state;
    }

    public Timer getRotationIdle() {
        return this.rotationIdle;
    }

    public void setCurrentRotation(Rotation currentRotation) {
        this.currentRotation = currentRotation;
    }

    public void setPrevRotation(Rotation prevRotation) {
        this.prevRotation = prevRotation;
    }

    public void setRenderRotation(Rotation renderRotation) {
        this.renderRotation = renderRotation;
    }

    public void setState(RotationState state) {
        this.state = state;
    }

    public void setCurrentTask(@Nullable RotationTask currentTask) {
        this.currentTask = currentTask;
    }

    @Nullable
    public RotationTask getCurrentTask() {
        return this.currentTask;
    }
}

