/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  com.mojang.blaze3d.systems.RenderSystem
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 *  net.minecraft.class_10156
 *  net.minecraft.class_286
 *  net.minecraft.class_287
 *  net.minecraft.class_289
 *  net.minecraft.class_290
 *  net.minecraft.class_293$class_5596
 *  net.minecraft.class_4588
 *  net.minecraft.class_5944
 *  net.minecraft.class_9801
 *  org.joml.Matrix4f
 */
package moscow.rockstar.utility.render.batching;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import moscow.rockstar.framework.msdf.MsdfFont;
import moscow.rockstar.framework.msdf.MsdfRenderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10156;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4588;
import net.minecraft.class_5944;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public final class TextBatchManager {
    private static final Map<Integer, Batch> batches = new HashMap<Integer, Batch>();
    private static boolean globalBegun = false;

    public static void beginFrame() {
        if (globalBegun) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        globalBegun = true;
    }

    public static void addText(MsdfFont font, String text, float size, int color, Matrix4f matrix, float x, float y, float z, float thickness, float spacing) {
        int key;
        Batch batch;
        if (!globalBegun) {
            TextBatchManager.beginFrame();
        }
        if ((batch = batches.get(key = font.getTextureId())) == null) {
            batch = new Batch(font);
            batches.put(key, batch);
            RenderSystem.setShaderTexture((int)0, (int)font.getTextureId());
            class_5944 shader = RenderSystem.setShader((class_10156)MsdfRenderer.MSDF_FONT_SHADER_KEY);
            shader.method_34582("Range").method_1251(font.getAtlas().range());
            shader.method_34582("Thickness").method_1251(thickness);
            shader.method_34582("Smoothness").method_1251(0.5f);
            shader.method_34582("EnableFadeout").method_35649(0);
            batch.begun = true;
        }
        font.applyGlyphs(matrix, (class_4588)batch.builder, text, size, thickness * 0.5f * size, spacing, x - 0.75f, y + size * 0.7f, z, color);
    }

    public static void addTextWithFade(MsdfFont font, String text, float size, int color, Matrix4f matrix, float x, float y, float z, float thickness, float spacing, float fadeoutStart, float fadeoutEnd, float maxWidth, float textPosX) {
        class_5944 shader;
        int key;
        Batch batch;
        if (!globalBegun) {
            TextBatchManager.beginFrame();
        }
        if ((batch = batches.get(key = font.getTextureId())) == null) {
            batch = new Batch(font);
            batches.put(key, batch);
            RenderSystem.setShaderTexture((int)0, (int)font.getTextureId());
            shader = RenderSystem.setShader((class_10156)MsdfRenderer.MSDF_FONT_SHADER_KEY);
            shader.method_34582("Range").method_1251(font.getAtlas().range());
            shader.method_34582("Thickness").method_1251(thickness);
            shader.method_34582("Smoothness").method_1251(0.5f);
            batch.begun = true;
        }
        shader = RenderSystem.getShader();
        shader.method_34582("EnableFadeout").method_35649(1);
        shader.method_34582("FadeoutStart").method_1251(fadeoutStart);
        shader.method_34582("FadeoutEnd").method_1251(fadeoutEnd);
        shader.method_34582("MaxWidth").method_1251(maxWidth);
        shader.method_34582("TextPosX").method_1251(textPosX);
        font.applyGlyphs(matrix, (class_4588)batch.builder, text, size, thickness * 0.5f * size, spacing, x - 0.75f, y + size * 0.7f, z, color);
    }

    public static void endFrame() {
        if (!globalBegun) {
            return;
        }
        for (Batch batch : batches.values()) {
            class_9801 built = batch.builder.method_60794();
            if (built == null) continue;
            class_286.method_43433((class_9801)built);
        }
        RenderSystem.setShaderTexture((int)0, (int)0);
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        batches.clear();
        globalBegun = false;
    }

    @Environment(value=EnvType.CLIENT)
    private static final class Batch {
        final MsdfFont font;
        final class_287 builder;
        boolean begun = false;

        Batch(MsdfFont font) {
            this.font = font;
            this.builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        }
    }
}

