/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  com.mojang.blaze3d.systems.RenderSystem
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 *  net.minecraft.class_10142
 *  net.minecraft.class_10156
 *  net.minecraft.class_287
 *  net.minecraft.class_289
 *  net.minecraft.class_290
 *  net.minecraft.class_293$class_5596
 *  net.minecraft.class_4587
 *  org.joml.Matrix4f
 *  org.joml.Vector3f
 */
package moscow.rockstar.utility.render;

import com.mojang.blaze3d.systems.RenderSystem;
import moscow.rockstar.utility.colors.ColorRGBA;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public final class CrystalRenderer {
    private static final Vector3f[] VERTICES = new Vector3f[]{new Vector3f(0.0f, 1.5f, 0.0f), new Vector3f(0.0f, -1.5f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, -1.0f)};
    private static final int[][] FACES = new int[][]{{0, 2, 4}, {0, 4, 3}, {0, 3, 5}, {0, 5, 2}, {1, 4, 2}, {1, 3, 4}, {1, 5, 3}, {1, 2, 5}};
    private static final float[] FACE_BRIGHTNESS = new float[]{1.0f, 0.8f, 0.6f, 0.9f, 0.7f, 0.5f, 0.4f, 0.6f};

    public static void render(class_4587 matrices, class_287 buffer, float x, float y, float z, float size, ColorRGBA color) {
        matrices.method_22903();
        matrices.method_46416(x, y, z);
        matrices.method_22905(size, size, size);
        Matrix4f transformationMatrix = matrices.method_23760().method_23761();
        for (int i = 0; i < FACES.length; ++i) {
            int[] face = FACES[i];
            float brightness = FACE_BRIGHTNESS[i];
            Vector3f v1 = VERTICES[face[0]];
            Vector3f v2 = VERTICES[face[1]];
            Vector3f v3 = VERTICES[face[2]];
            int shadedColor = CrystalRenderer.applyBrightness(color.getRGB(), brightness);
            buffer.method_22918(transformationMatrix, v1.x, v1.y, v1.z).method_39415(shadedColor);
            buffer.method_22918(transformationMatrix, v2.x, v2.y, v2.z).method_39415(shadedColor);
            buffer.method_22918(transformationMatrix, v3.x, v3.y, v3.z).method_39415(shadedColor);
        }
        matrices.method_22909();
    }

    public static class_287 createBuffer() {
        CrystalRenderer.setupRenderState();
        return class_289.method_1348().method_60827(class_293.class_5596.field_27379, class_290.field_1576);
    }

    private static void setupRenderState() {
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static int applyBrightness(int color, float brightness) {
        int alpha = color >> 24 & 0xFF;
        int red = (int)((float)(color >> 16 & 0xFF) * brightness);
        int green = (int)((float)(color >> 8 & 0xFF) * brightness);
        int blue = (int)((float)(color & 0xFF) * brightness);
        red = Math.min(255, Math.max(0, red));
        green = Math.min(255, Math.max(0, green));
        blue = Math.min(255, Math.max(0, blue));
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    private CrystalRenderer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

