/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 *  net.minecraft.class_4587
 */
package moscow.rockstar.utility.gui;

import moscow.rockstar.utility.animation.base.Animation;
import moscow.rockstar.utility.animation.base.Easing;
import moscow.rockstar.utility.interfaces.IMinecraft;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class ScrollHandler
implements IMinecraft {
    private double max;
    private double value = 0.0;
    private double targetValue = 0.0;
    private double speed = 20.0;
    private static final double SCROLL_SMOOTHNESS = 0.4;
    public static final double SCROLLBAR_THICKNESS = 1.0;
    private final Animation scrollAnimation = new Animation(100L, Easing.BAKEK);

    public void update() {
        this.scrollAnimation.setDuration(300L);
        this.targetValue = Math.min(Math.max(this.targetValue, this.max), 0.0);
        double delta = this.targetValue - this.value;
        this.value = Math.abs(delta) < 5.0 ? (this.value += delta * 0.3) : (this.value += delta);
        if (delta > 0.0) {
            this.scrollAnimation.setEasing(Math.abs(delta) > 21.0 ? Easing.QUARTIC_OUT : Easing.BAKEK);
        }
        this.scrollAnimation.update((float)this.value);
    }

    public double getValue() {
        return -this.scrollAnimation.getValue();
    }

    public void reset() {
        this.value = 0.0;
        this.targetValue = 0.0;
        this.scrollAnimation.reset();
    }

    public void scroll(double amount) {
        this.targetValue += amount * this.speed;
    }

    public void onKeyPressed(int keyCode) {
        if (keyCode == 265) {
            this.scroll(1.0);
        } else if (keyCode == 264) {
            this.scroll(-1.0);
        }
    }

    public void renderScrollbar(class_4587 matrixStack, double x, double y, double width, double height, double contentHeight) {
        if (contentHeight <= height) {
            return;
        }
        double scrollbarHeight = 50.0;
        double scrollbarY = y + this.value / this.max * (height - scrollbarHeight);
    }

    public double getMax() {
        return this.max;
    }

    public double getTargetValue() {
        return this.targetValue;
    }

    public double getSpeed() {
        return this.speed;
    }

    public Animation getScrollAnimation() {
        return this.scrollAnimation;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setTargetValue(double targetValue) {
        this.targetValue = targetValue;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }
}

