/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 *  net.minecraft.class_1923
 */
package moscow.rockstar.utility.chunkanimator;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1923;

@Environment(value=EnvType.CLIENT)
public class ChunkAnimator {
    private static final Map<class_1923, ChunkAnimation> animatingChunks = new ConcurrentHashMap<class_1923, ChunkAnimation>();
    private static final long ANIMATION_DURATION = 1000L;

    public static void startAnimation(class_1923 pos, float worldY) {
        float startY = worldY - 64.0f;
        animatingChunks.put(pos, new ChunkAnimation(startY, worldY));
    }

    public static Float getAnimationOffset(class_1923 pos) {
        ChunkAnimation anim = animatingChunks.get(pos);
        if (anim == null) {
            return null;
        }
        if (anim.isFinished()) {
            animatingChunks.remove(pos);
            return null;
        }
        return Float.valueOf(anim.getCurrentY() - anim.targetY);
    }

    @Environment(value=EnvType.CLIENT)
    public static class ChunkAnimation {
        public final long startTime = System.currentTimeMillis();
        public final float startY;
        public final float targetY;

        public ChunkAnimation(float startY, float targetY) {
            this.startY = startY;
            this.targetY = targetY;
        }

        public float getCurrentY() {
            long elapsed = System.currentTimeMillis() - this.startTime;
            if (elapsed >= 1000L) {
                return this.targetY;
            }
            float progress = (float)elapsed / 1000.0f;
            return this.startY + (this.targetY - this.startY) * progress;
        }

        public boolean isFinished() {
            return System.currentTimeMillis() - this.startTime >= 1000L;
        }
    }
}

