/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  com.mojang.blaze3d.systems.RenderSystem
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 *  net.minecraft.class_243
 *  net.minecraft.class_287
 *  net.minecraft.class_2960
 *  net.minecraft.class_4184
 *  net.minecraft.class_4587
 *  net.minecraft.class_7833
 *  org.joml.Matrix4f
 */
package moscow.rockstar.utility;

import com.mojang.blaze3d.systems.RenderSystem;
import moscow.rockstar.utility.animation.base.Animation;
import moscow.rockstar.utility.animation.base.Easing;
import moscow.rockstar.utility.colors.ColorRGBA;
import moscow.rockstar.utility.interfaces.IMinecraft;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class CustomParticle
implements IMinecraft {
    private class_243 position;
    private class_243 prevPosition;
    private class_243 velocity;
    private float size = 3.0f;
    private final class_2960 texture;
    private int age;
    private int maxAge = 100;
    private double gravityStrength = 0.04;
    private boolean alive;
    private boolean collidesWithWorld;
    private final Animation alphaAnimation;
    private final Animation sizeAnimation;
    private final ColorRGBA color;

    public CustomParticle(class_243 position, class_243 velocity, class_2960 texture, ColorRGBA color) {
        this.position = position;
        this.prevPosition = position;
        this.velocity = velocity;
        this.texture = texture;
        this.color = color;
        this.age = 0;
        long animationDuration = this.maxAge * 5;
        this.alphaAnimation = new Animation(animationDuration, Easing.CUBIC_IN_OUT);
        this.sizeAnimation = new Animation(animationDuration, Easing.LINEAR);
        this.alive = true;
    }

    public void tick() {
        ++this.age;
        if (this.age >= this.maxAge) {
            this.markDead();
        }
        this.prevPosition = this.position;
        this.position = this.position.method_1019(this.velocity);
    }

    public void render(class_287 builder, class_4184 camera) {
        this.alphaAnimation.update(this.isDead() ? 0.0f : 1.0f);
        this.sizeAnimation.update(this.isDead() ? 0.0f : 1.0f);
        float currentSize = 10.0f;
        ColorRGBA renderColor = ColorRGBA.fromInt(this.color.getRGB()).withAlpha(255.0f * this.alphaAnimation.getValue());
        RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
        class_4587 matrices = new class_4587();
        Matrix4f matrix = matrices.method_23760().method_23761();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
        class_243 renderPos = this.getRenderPos(this.prevPosition, this.position);
        matrices.method_22904(renderPos.method_10216(), renderPos.method_10214(), renderPos.method_10215());
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-camera.method_19330()));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        builder.method_22918(matrix, 0.0f, -currentSize, 0.0f).method_22913(0.0f, 1.0f).method_39415(renderColor.getRGB());
        builder.method_22918(matrix, -currentSize, -currentSize, 0.0f).method_22913(1.0f, 1.0f).method_39415(renderColor.getRGB());
        builder.method_22918(matrix, -currentSize, 0.0f, 0.0f).method_22913(1.0f, 0.0f).method_39415(renderColor.getRGB());
        builder.method_22918(matrix, 0.0f, 0.0f, 0.0f).method_22913(0.0f, 0.0f).method_39415(renderColor.getRGB());
    }

    public void setPosition(double x, double y, double z) {
        this.position = new class_243(x, y, z);
    }

    public void setVelocity(double x, double y, double z) {
        this.velocity = new class_243(x, y, z);
    }

    private void markDead() {
        this.alive = false;
    }

    public boolean isDead() {
        return !this.alive;
    }

    public boolean shouldRemove() {
        return this.isDead() && this.alphaAnimation.getValue() == 0.0f;
    }

    private class_243 getRenderPos(class_243 prevPosition, class_243 position) {
        double x = prevPosition.method_10216() + (position.method_10216() - prevPosition.method_10216()) * (double)CustomParticle.getTickDelta() - CustomParticle.mc.method_1561().field_4686.method_19326().method_10216();
        double y = prevPosition.method_10214() + (position.method_10214() - prevPosition.method_10214()) * (double)CustomParticle.getTickDelta() - CustomParticle.mc.method_1561().field_4686.method_19326().method_10214();
        double z = prevPosition.method_10215() + (position.method_10215() - prevPosition.method_10215()) * (double)CustomParticle.getTickDelta() - CustomParticle.mc.method_1561().field_4686.method_19326().method_10215();
        return new class_243(x, y, z);
    }

    private static float getTickDelta() {
        return mc.method_61966().method_60637(false);
    }

    public class_243 getPosition() {
        return this.position;
    }

    public class_243 getPrevPosition() {
        return this.prevPosition;
    }

    public class_243 getVelocity() {
        return this.velocity;
    }

    public float getSize() {
        return this.size;
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    public int getAge() {
        return this.age;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public double getGravityStrength() {
        return this.gravityStrength;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public boolean isCollidesWithWorld() {
        return this.collidesWithWorld;
    }

    public Animation getAlphaAnimation() {
        return this.alphaAnimation;
    }

    public Animation getSizeAnimation() {
        return this.sizeAnimation;
    }

    public ColorRGBA getColor() {
        return this.color;
    }

    public void setPosition(class_243 position) {
        this.position = position;
    }

    public void setPrevPosition(class_243 prevPosition) {
        this.prevPosition = prevPosition;
    }

    public void setVelocity(class_243 velocity) {
        this.velocity = velocity;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public void setGravityStrength(double gravityStrength) {
        this.gravityStrength = gravityStrength;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public void setCollidesWithWorld(boolean collidesWithWorld) {
        this.collidesWithWorld = collidesWithWorld;
    }
}

