/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 *  net.minecraft.class_241
 */
package moscow.rockstar.ui.menu.dropdown.components.settings.impl;

import moscow.rockstar.framework.base.CustomComponent;
import moscow.rockstar.framework.base.UIContext;
import moscow.rockstar.framework.msdf.Font;
import moscow.rockstar.framework.msdf.Fonts;
import moscow.rockstar.framework.objects.BorderRadius;
import moscow.rockstar.framework.objects.MouseButton;
import moscow.rockstar.systems.localization.Localizator;
import moscow.rockstar.systems.setting.settings.BezierSetting;
import moscow.rockstar.ui.menu.dropdown.components.settings.MenuSettingComponent;
import moscow.rockstar.utility.animation.base.Animation;
import moscow.rockstar.utility.animation.base.Easing;
import moscow.rockstar.utility.colors.ColorRGBA;
import moscow.rockstar.utility.colors.Colors;
import moscow.rockstar.utility.game.cursor.CursorType;
import moscow.rockstar.utility.game.cursor.CursorUtility;
import moscow.rockstar.utility.gui.GuiUtility;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_241;

@Environment(value=EnvType.CLIENT)
public class BezierSettingComponent
extends MenuSettingComponent<BezierSetting> {
    private final Animation startX = new Animation(500L, Easing.BAKEK_PAGES);
    private final Animation startY = new Animation(500L, Easing.BAKEK_PAGES);
    private final Animation endX = new Animation(500L, Easing.BAKEK_PAGES);
    private final Animation endY = new Animation(500L, Easing.BAKEK_PAGES);
    private boolean dragStart;
    private boolean dragEnd;

    public BezierSettingComponent(BezierSetting setting, CustomComponent parent) {
        super(setting, parent);
    }

    @Override
    protected void renderComponent(UIContext context) {
        float x = this.x + 9.0f;
        float y = this.y + 2.0f;
        float width = this.width - 18.0f;
        Font nameFont = Fonts.REGULAR.getFont(8.0f);
        float leftPadding = 10.0f;
        float nameHeight = Fonts.REGULAR.getFont(7.0f).height();
        this.hoverAnimation.update(this.isHovered(context.getMouseX(), context.getMouseY()));
        float offset = 3.0f;
        float boxX = x - 1.0f + offset;
        float boxY = y + 17.0f + offset;
        float boxWidth = width + 2.0f - offset * 2.0f;
        float boxHeight = this.height - 10.0f - 17.0f - offset * 2.0f;
        context.drawRoundedRect(boxX - offset, boxY - offset, boxWidth + offset * 2.0f, boxHeight + offset * 2.0f, BorderRadius.all(6.0f), Colors.getBackgroundColor().withAlpha(76.5f));
        context.drawRoundedRect(boxX + this.startX.getValue() * boxWidth - 3.0f, boxY + this.startY.getValue() * boxHeight - 3.0f, 6.0f, 6.0f, BorderRadius.all(6.0f), Colors.WHITE.withAlpha(255.0f));
        context.drawRoundedRect(boxX + this.endX.getValue() * boxWidth - 3.0f, boxY + this.endY.getValue() * boxHeight - 3.0f, 6.0f, 6.0f, BorderRadius.all(6.0f), Colors.WHITE.withAlpha(255.0f));
        class_241 anchorStart = new class_241(boxX, boxY + boxHeight);
        class_241 controlStart = new class_241(boxX + this.startX.getValue() * boxWidth, boxY + this.startY.getValue() * boxHeight);
        class_241 controlEnd = new class_241(boxX + this.endX.getValue() * boxWidth, boxY + this.endY.getValue() * boxHeight);
        class_241 anchorEnd = new class_241(boxX + boxWidth, boxY);
        context.drawBezier(anchorStart, controlStart, controlEnd, anchorEnd, ColorRGBA.WHITE, 50);
        context.drawLine(anchorStart, controlStart, Colors.WHITE.mulAlpha(0.5f));
        context.drawLine(anchorEnd, controlEnd, Colors.WHITE.mulAlpha(0.5f));
        context.drawFadeoutText(nameFont, Localizator.translate(((BezierSetting)this.setting).getName()), this.x + leftPadding, y + 11.0f - nameFont.height(), Colors.getTextColor().withAlpha(255.0f * (0.75f + 0.25f * this.hoverAnimation.getValue())), 0.8f, 1.0f, this.getParent().getWidth() - leftPadding - 10.0f);
        if (this.isHovered(context.getMouseX(), context.getMouseY())) {
            CursorUtility.set(CursorType.HAND);
        }
        if (this.dragStart) {
            float xValue = GuiUtility.getSliderValue(0.0f, 1.0f, boxX, boxWidth, context.getMouseX());
            float yValue = GuiUtility.getSliderValueWithoutClamp(0.0f, 1.0f, boxY, boxHeight, context.getMouseY());
            ((BezierSetting)this.setting).start(new class_241(xValue, Math.clamp((float)yValue, (float)-0.5f, (float)1.5f)));
            CursorUtility.set(CursorType.CROSSHAIR);
        } else if (this.dragEnd) {
            float xValue = GuiUtility.getSliderValue(0.0f, 1.0f, boxX, boxWidth, context.getMouseX());
            float yValue = GuiUtility.getSliderValueWithoutClamp(0.0f, 1.0f, boxY, boxHeight, context.getMouseY());
            ((BezierSetting)this.setting).end(new class_241(xValue, Math.clamp((float)yValue, (float)-0.5f, (float)1.5f)));
            CursorUtility.set(CursorType.CROSSHAIR);
        }
        this.startX.setValue(((BezierSetting)this.setting).start().field_1343);
        this.startY.setValue(((BezierSetting)this.setting).start().field_1342);
        this.endX.setValue(((BezierSetting)this.setting).end().field_1343);
        this.endY.setValue(((BezierSetting)this.setting).end().field_1342);
    }

    @Override
    public void drawSplit(UIContext context) {
        float separatorHeight = 0.5f;
        context.drawRect(this.x, this.y + this.height, this.width, separatorHeight, Colors.getTextColor().withAlpha(5.1f));
    }

    @Override
    public void onMouseClicked(double mouseX, double mouseY, MouseButton button) {
        float x = this.x + 9.0f;
        float y = this.y + 2.0f;
        float width = this.width - 18.0f;
        if (this.isHovered(mouseX, mouseY)) {
            float f;
            float boxX = x - 1.0f;
            float boxY = y + 17.0f;
            float boxWidth = width + 2.0f;
            float boxHeight = this.height - 10.0f - 17.0f;
            class_241 mouse = new class_241(GuiUtility.getPercent((float)mouseX, boxX, boxX + boxWidth), GuiUtility.getPercent((float)mouseY, boxY, boxY + boxHeight));
            float startDist = this.distance(((BezierSetting)this.setting).start(), mouse);
            float endDist = this.distance(((BezierSetting)this.setting).end(), mouse);
            if (startDist < f) {
                this.dragStart = true;
            } else {
                this.dragEnd = true;
            }
        }
        super.onMouseClicked(mouseX, mouseY, button);
    }

    public float distance(class_241 vec, class_241 vec2) {
        float f = vec.field_1343 - vec2.field_1343;
        float g = vec.field_1342 - vec2.field_1342;
        return (float)Math.sqrt(f * f + g * g);
    }

    @Override
    public void onMouseReleased(double mouseX, double mouseY, MouseButton button) {
        this.dragStart = false;
        this.dragEnd = false;
        super.onMouseReleased(mouseX, mouseY, button);
    }

    @Override
    public float getHeight() {
        this.height = this.width - 14.0f;
        return this.height;
    }
}

