/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 *  net.minecraft.class_290
 *  net.minecraft.class_304
 *  net.minecraft.class_332
 *  net.minecraft.class_3675
 *  net.minecraft.class_437
 */
package moscow.rockstar.ui.menu.dropdown;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import moscow.rockstar.Rockstar;
import moscow.rockstar.framework.base.UIContext;
import moscow.rockstar.framework.msdf.Fonts;
import moscow.rockstar.framework.objects.BorderRadius;
import moscow.rockstar.framework.objects.MouseButton;
import moscow.rockstar.systems.localization.Localizator;
import moscow.rockstar.systems.modules.Module;
import moscow.rockstar.systems.modules.modules.other.Sounds;
import moscow.rockstar.systems.modules.modules.visuals.Interface;
import moscow.rockstar.systems.modules.modules.visuals.MenuModule;
import moscow.rockstar.systems.theme.Theme;
import moscow.rockstar.ui.components.ColorPicker;
import moscow.rockstar.ui.components.animated.AnimatedText;
import moscow.rockstar.ui.components.textfield.FieldAction;
import moscow.rockstar.ui.components.textfield.TextField;
import moscow.rockstar.ui.menu.MenuScreen;
import moscow.rockstar.ui.menu.api.MenuCategory;
import moscow.rockstar.ui.menu.dropdown.components.MenuPanel;
import moscow.rockstar.ui.menu.dropdown.components.module.ModuleComponent;
import moscow.rockstar.ui.menu.dropdown.components.settings.impl.BezierSettingComponent;
import moscow.rockstar.ui.menu.dropdown.components.settings.impl.BindSettingComponent;
import moscow.rockstar.ui.menu.dropdown.components.settings.impl.BooleanSettingComponent;
import moscow.rockstar.ui.menu.dropdown.components.settings.impl.ButtonSettingComponent;
import moscow.rockstar.ui.menu.dropdown.components.settings.impl.ColorSettingComponent;
import moscow.rockstar.ui.menu.dropdown.components.settings.impl.ModeSettingComponent;
import moscow.rockstar.ui.menu.dropdown.components.settings.impl.RangeSettingComponent;
import moscow.rockstar.ui.menu.dropdown.components.settings.impl.SliderSettingComponent;
import moscow.rockstar.ui.menu.dropdown.components.settings.impl.StringSettingComponent;
import moscow.rockstar.utility.animation.base.Animation;
import moscow.rockstar.utility.animation.base.Easing;
import moscow.rockstar.utility.colors.ColorRGBA;
import moscow.rockstar.utility.colors.Colors;
import moscow.rockstar.utility.interfaces.IMinecraft;
import moscow.rockstar.utility.math.MathUtility;
import moscow.rockstar.utility.render.RenderUtility;
import moscow.rockstar.utility.render.ScissorUtility;
import moscow.rockstar.utility.render.batching.Batching;
import moscow.rockstar.utility.render.batching.impl.FontBatching;
import moscow.rockstar.utility.render.batching.impl.IconBatching;
import moscow.rockstar.utility.render.batching.impl.RectBatching;
import moscow.rockstar.utility.sounds.ClientSounds;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_290;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import ru.kotopushka.compiler.sdk.annotations.Compile;

@Environment(value=EnvType.CLIENT)
public class DropDownScreen
extends MenuScreen
implements IMinecraft {
    private final Animation searchAnimation = new Animation(300L, Easing.BAKEK);
    private final Animation appendingAnim = new Animation(300L, Easing.BAKEK);
    private boolean closing;
    private List<MenuPanel> panels = new ArrayList<MenuPanel>();
    private float panelWidth;
    private float panelHeight;
    private String desc = "";
    private AnimatedText descText;
    private final List<ColorPicker> colorPickers = new ArrayList<ColorPicker>();
    private TextField searchField;

    @Compile
    protected void method_25426() {
        this.descText = new AnimatedText(Fonts.REGULAR.getFont(10.0f), 10.0f, 300L, Easing.BAKEK).centered();
        this.closing = false;
        this.panelWidth = 115.0f;
        this.panelHeight = 240.0f;
        this.panels = Arrays.stream(MenuCategory.values()).map(MenuPanel::new).toList();
        for (MenuPanel panel : this.panels) {
            panel.setWidth(this.panelWidth);
            panel.setHeight(this.panelHeight);
            panel.onInit();
        }
        this.searchField = new TextField(Fonts.REGULAR.getFont(12.0f));
        HashMap<String, FieldAction> append = new HashMap<String, FieldAction>();
        for (Module module : Rockstar.getInstance().getModuleManager().getModules()) {
            FieldAction action = new FieldAction(module::toggle, () -> this.panels.forEach(panel -> panel.getModuleComponents().stream().filter(component -> component.getModule() == module).forEach(ModuleComponent::open)));
            append.put(module.getName().replace(" ", ""), action);
            append.put(module.getName(), action);
        }
        this.searchField.setAppend(append);
        if (this.openedModuleName != null) {
            block2: for (MenuPanel panel : this.panels) {
                for (ModuleComponent comp : panel.getModuleComponents()) {
                    if (!comp.getModule().getName().equals(this.openedModuleName)) continue;
                    comp.open();
                    continue block2;
                }
            }
            this.openedModuleName = null;
        }
        super.method_25426();
    }

    public void method_25393() {
        this.handleMovementKeys();
        super.method_25393();
    }

    @Override
    @Compile
    public void render(UIContext context) {
        this.menuAnimation.setEasing(Easing.LINEAR);
        this.menuAnimation.update(this.isClosing() ? 0.0f : 1.0f);
        this.menuAnimation.setDuration(this.isClosing() ? 300L : 500L);
        this.desc = "";
        float spacing = 10.0f;
        float x = ((float)this.field_22789 - (this.panelWidth + spacing) * (float)this.panels.size() + spacing) / 2.0f;
        float y = ((float)this.field_22790 - this.panelHeight) / 2.0f;
        context.pushMatrix();
        float offset = 0.0f;
        for (MenuPanel menuPanel : this.panels) {
            menuPanel.setX(MathUtility.interpolate(x + offset, (float)this.field_22789 / 2.0f - this.panelWidth / 2.0f, this.closing ? (double)(1.0f - this.menuAnimation.getValue()) : 0.0));
            menuPanel.setY(y);
            menuPanel.setWidth(this.panelWidth);
            menuPanel.setHeight(this.panelHeight);
            offset += this.panelWidth + spacing;
        }
        for (MenuPanel menuPanel : this.panels) {
            menuPanel.renderBlur(context);
            offset += this.panelWidth + spacing;
        }
        for (MenuPanel menuPanel : this.panels) {
            menuPanel.render(context);
        }
        IconBatching icon = new IconBatching(class_290.field_1575, context.method_51448());
        for (MenuPanel panel : this.panels) {
            panel.drawType(context);
        }
        ((Batching)icon).draw();
        for (MenuPanel panel : this.panels) {
            this.scissor(context, panel, () -> {
                FontBatching font = new FontBatching(class_290.field_1575, Fonts.REGULAR);
                panel.drawRegular8(context);
                ((Batching)font).draw();
                IconBatching icon1 = new IconBatching(class_290.field_1575, context.method_51448());
                panel.drawIcons(context);
                ((Batching)icon1).draw();
                RectBatching split = new RectBatching(class_290.field_1576, context.method_51448());
                panel.drawSplit(context);
                ((Batching)split).draw();
            });
        }
        context.popMatrix();
        if (this.menuAnimation.getValue() < 0.5f) {
            this.desc = "";
        }
        this.searchAnimation.update(this.searchField.isFocused());
        float f = this.menuAnimation.getValue() * this.searchAnimation.getValue();
        if (f > 0.0f) {
            if (Interface.showMinimalizm()) {
                context.drawBlurredRect(this.searchField.getX(), this.searchField.getY(), this.searchField.getWidth(), this.searchField.getHeight(), 45.0f, BorderRadius.all(6.0f), ColorRGBA.WHITE.withAlpha(255.0f * f));
            }
            if (Interface.showGlass()) {
                context.drawLiquidGlass(this.searchField.getX(), this.searchField.getY(), this.searchField.getWidth(), this.searchField.getHeight(), 2.0f, 0.08f, BorderRadius.all(6.0f), ColorRGBA.WHITE.withAlpha(255.0f * f));
            }
            boolean dark = Rockstar.getInstance().getThemeManager().getCurrentTheme() == Theme.DARK;
            context.drawRoundedRect(this.searchField.getX(), this.searchField.getY(), this.searchField.getWidth(), this.searchField.getHeight(), BorderRadius.all(6.0f), Colors.getBackgroundColor().withAlpha(255.0f * (dark ? 0.9f - 0.7f * Interface.glass() : 0.7f) * f));
            this.searchField.set((float)this.field_22789 / 2.0f - this.searchField.getWidth() / 2.0f, (float)(this.field_22790 - 20) - 20.0f * f, 100.0f, 20.0f);
            this.searchField.setAlpha(f);
            this.searchField.setTextColor(Colors.getTextColor());
            this.searchField.render(context);
            this.appendingAnim.update(!this.searchField.getAppending().isBlank());
            context.drawCenteredText(Fonts.MEDIUM.getFont(11.0f), Localizator.translate("search.tooltip.tab"), (float)this.field_22789 / 2.0f, (float)(this.field_22790 - 65) - 10.0f * f * this.appendingAnim.getValue(), ColorRGBA.WHITE.withAlpha(150.0f * f * this.appendingAnim.getValue()));
            context.drawCenteredText(Fonts.MEDIUM.getFont(11.0f), Localizator.translate("search.tooltip.enter"), (float)this.field_22789 / 2.0f, (float)(this.field_22790 - 50) - 10.0f * f * this.appendingAnim.getValue(), ColorRGBA.WHITE.withAlpha(150.0f * f * this.appendingAnim.getValue()));
        } else {
            this.searchField.clear();
        }
        context.drawCenteredText(Fonts.MEDIUM.getFont(11.0f), Localizator.translate("search.tooltip"), (float)this.field_22789 / 2.0f, (float)(this.field_22790 - 20) - 10.0f * this.menuAnimation.getValue() * (1.0f - this.searchAnimation.getValue()), ColorRGBA.WHITE.withAlpha(150.0f * this.menuAnimation.getValue() * (1.0f - this.searchAnimation.getValue())));
        this.descText.pos((float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f - 150.0f);
        if (!this.desc.contains(".description")) {
            this.descText.update(this.desc);
            this.descText.render(context);
        }
        for (ColorPicker colorPicker : this.colorPickers) {
            colorPicker.render(context);
            if (DropDownScreen.mc.field_1755 instanceof DropDownScreen) continue;
            colorPicker.setShowing(false);
        }
        this.colorPickers.removeIf(popup -> popup.getAnimation().getValue() == 0.0f && !popup.isShowing());
    }

    @Compile
    private void handleMovementKeys() {
        if (DropDownScreen.mc.field_1724 == null || this.isTyping()) {
            return;
        }
        long windowHandle = mc.method_22683().method_4490();
        class_304[] movementKeys = new class_304[]{DropDownScreen.mc.field_1690.field_1894, DropDownScreen.mc.field_1690.field_1881, DropDownScreen.mc.field_1690.field_1913, DropDownScreen.mc.field_1690.field_1849, DropDownScreen.mc.field_1690.field_1903};
        for (class_304 key : movementKeys) {
            int keyCode = class_3675.method_15981((String)key.method_1428()).method_1444();
            key.method_23481(class_3675.method_15987((long)windowHandle, (int)keyCode));
        }
        if (DropDownScreen.mc.field_1724.method_31549().field_7479) {
            int keyCode = class_3675.method_15981((String)DropDownScreen.mc.field_1690.field_1832.method_1428()).method_1444();
            DropDownScreen.mc.field_1690.field_1832.method_23481(class_3675.method_15987((long)windowHandle, (int)keyCode));
        }
    }

    private boolean isTyping() {
        return DropDownScreen.mc.field_1755 != null && TextField.LAST_FIELD != null && TextField.LAST_FIELD.isFocused();
    }

    public boolean isBindingModule() {
        return this.panels.stream().flatMap(panel -> panel.getModuleComponents().stream()).anyMatch(ModuleComponent::isBindingMode);
    }

    private void scissor(UIContext context, MenuPanel panel, Runnable runnable) {
        panel.scale(context);
        panel.push(context);
        runnable.run();
        ScissorUtility.pop();
        RenderUtility.end(context.method_51448());
    }

    @Override
    @Compile
    public void onMouseClicked(double mouseX, double mouseY, MouseButton button) {
        if (Rockstar.getInstance().getHud().getIsland().handleClick((float)mouseX, (float)mouseY, button.getButtonIndex())) {
            return;
        }
        for (ColorPicker colorPicker : this.colorPickers) {
            boolean isPick = colorPicker.isPick();
            colorPicker.onMouseClicked(mouseX, mouseY, button);
            if (colorPicker.isHovered(mouseX, mouseY) || isPick) {
                return;
            }
            colorPicker.setShowing(false);
        }
        for (MenuPanel panel : this.panels) {
            if (!panel.isHovered(mouseX, mouseY)) continue;
            panel.onMouseClicked(mouseX, mouseY, button);
        }
        if (this.searchField.isFocused() && button != MouseButton.MIDDLE) {
            this.searchField.onMouseClicked(mouseX, mouseY, button);
        }
        super.onMouseClicked(mouseX, mouseY, button);
    }

    @Override
    @Compile
    public void onMouseReleased(double mouseX, double mouseY, MouseButton button) {
        for (ColorPicker colorPicker : this.colorPickers) {
            colorPicker.onMouseReleased(mouseX, mouseY, button);
        }
        for (MenuPanel panel : this.panels) {
            panel.onMouseReleased(mouseX, mouseY, button);
        }
        if (this.searchField.isFocused()) {
            this.searchField.onMouseReleased(mouseX, mouseY, button);
        }
        super.onMouseReleased(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        for (MenuPanel panel : this.panels) {
            panel.onScroll(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Compile
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        MenuModule menuModule = Rockstar.getInstance().getModuleManager().getModule(MenuModule.class);
        if (!(menuModule == null || menuModule.getKey() != keyCode || this.searchField != null && this.searchField.isFocused() || this.isBindingModule())) {
            if (MenuModule.canCloseWithKey()) {
                this.method_25419();
            }
            return true;
        }
        for (ColorPicker colorPicker : this.colorPickers) {
            colorPicker.onKeyPressed(keyCode, scanCode, modifiers);
        }
        if (this.searchField != null && !this.searchField.isFocused() && class_437.method_25441() && keyCode == 70) {
            this.searchField.setFocused(true);
        }
        for (MenuPanel panel : this.panels) {
            panel.onKeyPressed(keyCode, scanCode, modifiers);
        }
        if (this.searchField.isFocused() && !this.isBindingModule()) {
            this.searchField.onKeyPressed(keyCode, scanCode, modifiers);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Compile
    public boolean method_25400(char chr, int modifiers) {
        if (this.searchField.isFocused() && !this.isBindingModule()) {
            this.searchField.charTyped(chr, modifiers);
        }
        for (MenuPanel panel : this.panels) {
            panel.charTyped(chr, modifiers);
        }
        return super.method_25400(chr, modifiers);
    }

    @Compile
    public void method_25419() {
        this.closing = true;
        this.openedModuleName = null;
        for (MenuPanel panel : this.panels) {
            if (panel.getSelectedModuleComponent() == null) continue;
            this.openedModuleName = panel.getSelectedModuleComponent().getModule().getName();
            break;
        }
        Rockstar.getInstance().getModuleManager().getModule(MenuModule.class).disable();
        Sounds soundsModule = Rockstar.getInstance().getModuleManager().getModule(Sounds.class);
        if (soundsModule.isEnabled()) {
            ClientSounds.CLICKGUI_OPEN.play(soundsModule.getVolume().getCurrentValue(), 1.0f);
        }
        Rockstar.getInstance().getFileManager().writeFile("client");
        if (Rockstar.getInstance().getConfigManager().getCurrent() != null) {
            Rockstar.getInstance().getConfigManager().getCurrent().save();
        }
        if (TextField.LAST_FIELD != null) {
            TextField.LAST_FIELD.setFocused(false);
        }
        super.method_25419();
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public boolean method_25422() {
        return true;
    }

    public Animation getSearchAnimation() {
        return this.searchAnimation;
    }

    public Animation getAppendingAnim() {
        return this.appendingAnim;
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    public List<MenuPanel> getPanels() {
        return this.panels;
    }

    public float getPanelWidth() {
        return this.panelWidth;
    }

    public float getPanelHeight() {
        return this.panelHeight;
    }

    public String getDesc() {
        return this.desc;
    }

    public AnimatedText getDescText() {
        return this.descText;
    }

    public List<ColorPicker> getColorPickers() {
        return this.colorPickers;
    }

    @Override
    public void setClosing(boolean closing) {
        this.closing = closing;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public TextField getSearchField() {
        return this.searchField;
    }

    static {
        new MenuPanel(null);
        new BezierSettingComponent(null, null);
        new BindSettingComponent(null, null);
        new BooleanSettingComponent(null, null);
        new ModeSettingComponent(null, null);
        new ButtonSettingComponent(null, null);
        new ColorSettingComponent(null, null);
        new StringSettingComponent(null, null);
        new RangeSettingComponent(null, null);
        new SliderSettingComponent(null, null);
    }
}

