/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 *  net.minecraft.class_1294
 *  net.minecraft.class_1297
 *  net.minecraft.class_1309
 *  net.minecraft.class_1657
 *  net.minecraft.class_408
 *  net.minecraft.class_742
 */
package moscow.rockstar.ui.hud.impl;

import moscow.rockstar.Rockstar;
import moscow.rockstar.framework.base.UIContext;
import moscow.rockstar.framework.msdf.Font;
import moscow.rockstar.framework.msdf.Fonts;
import moscow.rockstar.framework.objects.BorderRadius;
import moscow.rockstar.framework.objects.MouseButton;
import moscow.rockstar.systems.modules.modules.visuals.Interface;
import moscow.rockstar.systems.setting.settings.ColorSetting;
import moscow.rockstar.systems.setting.settings.ModeSetting;
import moscow.rockstar.systems.theme.Theme;
import moscow.rockstar.ui.hud.HudElement;
import moscow.rockstar.utility.animation.base.Animation;
import moscow.rockstar.utility.animation.base.Easing;
import moscow.rockstar.utility.colors.ColorRGBA;
import moscow.rockstar.utility.colors.Colors;
import moscow.rockstar.utility.game.EntityUtility;
import moscow.rockstar.utility.game.TextUtility;
import moscow.rockstar.utility.gui.GuiUtility;
import moscow.rockstar.utility.render.RenderUtility;
import moscow.rockstar.utility.render.ScissorUtility;
import moscow.rockstar.utility.time.Timer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_408;
import net.minecraft.class_742;

@Environment(value=EnvType.CLIENT)
public class TargetHud
extends HudElement {
    private final ModeSetting style = new ModeSetting(this, "hud.targethud.style");
    private final ModeSetting.Value styleNew = new ModeSetting.Value(this.style, "hud.targethud.style.new").select();
    private final ModeSetting.Value styleMinimalism = new ModeSetting.Value(this.style, "hud.targethud.style.minimalism");
    private final ColorSetting hpColor = new ColorSetting(this, "\u0426\u0432\u0435\u0442").color(new ColorRGBA(138.0f, 43.0f, 226.0f));
    private final Animation content = new Animation(300L, 0.0f, Easing.BAKEK_SIZE);
    private final Animation health = new Animation(300L, 0.0f, Easing.BAKEK);
    private final Animation golden = new Animation(300L, 0.0f, Easing.BAKEK);
    private final Animation number = new Animation(300L, 0.0f, Easing.FIGMA_EASE_IN_OUT);
    private final Animation copy = new Animation(300L, 0.0f, Easing.BAKEK);
    private final Animation success = new Animation(500L, 0.0f, Easing.BAKEK_SIZE);
    private class_1309 target;
    private class_1309 lastTarget;
    private boolean wasOpenedFromChat = false;
    private final Timer targetLostTimer = new Timer();
    private final Timer copyTimer = new Timer();
    private boolean copied;

    private boolean isInvisibleTarget() {
        class_1309 class_13092 = this.target;
        if (!(class_13092 instanceof class_1309)) {
            return false;
        }
        class_1309 living = class_13092;
        return living.method_5767() || living.method_6059(class_1294.field_5905);
    }

    public TargetHud() {
        super("hud.targethud", "icons/hud/target.png");
    }

    @Override
    public void update(UIContext context) {
        super.update(context);
        if (this.styleMinimalism.isSelected()) {
            this.width = 120.0f;
            this.height = 36.0f;
        } else {
            this.width = 103.0f;
            this.height = 31.0f;
        }
    }

    @Override
    protected void renderComponent(UIContext context) {
        float f;
        float f2;
        boolean hover;
        class_1309 currentTarget = this.getTarget();
        boolean isChatOpen = TargetHud.mc.field_1755 instanceof class_408;
        if (currentTarget != null) {
            if (currentTarget == TargetHud.mc.field_1724 && isChatOpen) {
                this.wasOpenedFromChat = true;
            } else if (currentTarget != TargetHud.mc.field_1724) {
                this.wasOpenedFromChat = false;
            }
            this.target = currentTarget;
            this.lastTarget = currentTarget;
            this.targetLostTimer.reset();
        } else if (this.lastTarget != null) {
            if (this.wasOpenedFromChat && !isChatOpen) {
                this.target = null;
                this.lastTarget = null;
                this.wasOpenedFromChat = false;
            } else {
                double distance = TargetHud.mc.field_1724.method_5739((class_1297)this.lastTarget);
                boolean tooFar = distance > 15.0;
                boolean timeExpired = this.targetLostTimer.finished(3000L);
                boolean targetDead = this.lastTarget.method_29504();
                if (tooFar || timeExpired || targetDead) {
                    this.target = null;
                    this.lastTarget = null;
                    this.wasOpenedFromChat = false;
                } else {
                    this.target = this.lastTarget;
                }
            }
        }
        if (this.target == null) {
            return;
        }
        Font regular7 = Fonts.REGULAR.getFont(7.0f);
        Font semibold6 = Fonts.SEMIBOLD.getFont(6.0f);
        boolean dark = Rockstar.getInstance().getThemeManager().getCurrentTheme() == Theme.DARK;
        ColorRGBA bgColor = Colors.getBackgroundColor().withAlpha(255.0f * (dark ? 0.8f - 0.6f * Interface.glass() : 0.7f));
        boolean bl = hover = this.styleNew.isSelected() && GuiUtility.isHovered(this.x + 30.0f, this.y + 3.0f + 6.0f * this.content.getValue(), 60.0, 6.0, context);
        if (!hover || this.copyTimer.finished(1000L)) {
            this.copied = false;
        }
        this.copy.update(hover);
        this.success.update(this.copied);
        this.content.update(this.animation.getValue() * this.visible.getValue() >= 1.0f);
        class_1309 livingEntity = this.target;
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            f2 = EntityUtility.getHealth(player);
        } else {
            f2 = this.target.method_6032();
        }
        this.health.update(f2 / this.target.method_6063());
        this.golden.update(this.target.method_6067() / 20.0f);
        class_1309 livingEntity2 = this.target;
        if (livingEntity2 instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity2;
            f = EntityUtility.getHealth(player);
        } else {
            f = this.target.method_6032();
        }
        float healthNum = f;
        this.number.update(healthNum);
        if (this.animation.getValue() == 0.0f) {
            return;
        }
        context.drawShadow(this.x - 5.0f, this.y - 5.0f, this.width + 10.0f, this.height + 10.0f, 15.0f, BorderRadius.all(6.0f), ColorRGBA.BLACK.withAlpha(63.75f * this.dragAnim.getValue()));
        if (Interface.showMinimalizm()) {
            ColorRGBA minimalismColor = Interface.getMinimalismColor();
            float opacity = Interface.getMinimalismOpacity();
            context.drawBlurredRect(this.x, this.y, this.width, this.height, 45.0f, 7.0f, BorderRadius.all(6.0f), minimalismColor.withAlpha(255.0f * this.animation.getValue() * Interface.minimalizm() * opacity));
        }
        if (Interface.showGlass()) {
            context.drawLiquidGlass(this.x, this.y, this.width, this.height, 7.0f, 0.08f - 0.07f * this.dragAnim.getValue(), BorderRadius.all(6.0f), ColorRGBA.WHITE.withAlpha(255.0f * this.animation.getValue() * Interface.glass()));
        }
        context.drawSquircle(this.x, this.y, this.width, this.height, 7.0f, BorderRadius.all(6.0f), bgColor);
        float alpha = 255.0f * this.content.getValue();
        if (this.styleMinimalism.isSelected()) {
            this.renderMinimalism(context, regular7, semibold6, healthNum, alpha);
        } else {
            this.renderStyleNew(context, regular7, semibold6, healthNum, alpha);
        }
    }

    private void renderMinimalism(UIContext context, Font regular7, Font semibold6, float healthNum, float alpha) {
        float headSize = 24.0f;
        float padding = 5.0f;
        float barHeight = 4.0f;
        float barY = this.y + this.height - padding - barHeight;
        float barWidth = this.width - (padding + headSize + padding) - padding;
        float barX = this.x + padding + headSize + padding;
        ScissorUtility.push(context.method_51448(), this.x, this.y, this.width, this.height);
        class_1309 e = this.target;
        if (e instanceof class_742) {
            class_742 player = (class_742)e;
            context.drawHead(player, this.x + padding * this.content.getValue(), this.y + padding, headSize, BorderRadius.all(4.0f), Colors.WHITE.withAlpha(alpha));
        } else {
            context.drawRoundedTexture(Rockstar.id(Interface.glassSelected() ? "icons/hud/whoglass.png" : (Rockstar.getInstance().getThemeManager().getCurrentTheme() == Theme.DARK ? "icons/hud/whodark.png" : "icons/hud/who.png")), this.x + padding * this.content.getValue(), this.y + padding, headSize, headSize, BorderRadius.all(4.0f), Colors.WHITE.withAlpha(alpha));
        }
        boolean invis = this.isInvisibleTarget();
        String name = invis ? "(\u0438\u043d\u0432\u0438\u0437)" : this.target.method_5477().getString();
        float nameX = this.x + padding + headSize + padding;
        float nameY = this.y + padding;
        float maxNameW = barWidth - 4.0f;
        context.drawFadeoutText(regular7, name, nameX, nameY, Colors.getTextColor().withAlpha(alpha), 0.8f, 1.0f, maxNameW);
        String numberText = invis ? "?" : (healthNum == 1000.0f ? "?" : TextUtility.formatNumber(this.number.getValue()).replace(",", "."));
        context.drawRightText(semibold6, numberText, this.x + this.width - padding, nameY, this.hpColor.getColor().withAlpha(alpha));
        context.drawRoundedRect(barX, barY, barWidth, barHeight, BorderRadius.all(2.0f), Colors.getAdditionalColor().withAlpha(alpha * (1.0f - 0.7f * Interface.glass())));
        context.drawRoundedRect(barX, barY, barWidth * Math.clamp((float)this.health.getValue(), (float)0.0f, (float)1.0f), barHeight, BorderRadius.all(2.0f), this.hpColor.getColor().withAlpha(alpha));
        float goldenW = barWidth * Math.clamp((float)this.golden.getValue(), (float)0.0f, (float)1.0f);
        context.drawRoundedRect(barX + barWidth - goldenW, barY, goldenW, barHeight, BorderRadius.all(2.0f), new ColorRGBA(255.0f, 220.0f, 81.0f, alpha));
        ScissorUtility.pop();
    }

    private void renderStyleNew(UIContext context, Font regular7, Font semibold6, float healthNum, float alpha) {
        ScissorUtility.push(context.method_51448(), this.x, this.y, this.width, this.height);
        class_1309 livingEntity3 = this.target;
        if (livingEntity3 instanceof class_742) {
            class_742 player = (class_742)livingEntity3;
            context.drawHead(player, this.x + 6.0f * this.content.getValue(), this.y + 6.0f, 19.0f, BorderRadius.all(3.0f), Colors.WHITE.withAlpha(alpha));
        } else {
            context.drawRoundedTexture(Rockstar.id(Interface.glassSelected() ? "icons/hud/whoglass.png" : (Rockstar.getInstance().getThemeManager().getCurrentTheme() == Theme.DARK ? "icons/hud/whodark.png" : "icons/hud/who.png")), this.x + 6.0f * this.content.getValue(), this.y + 6.0f, 19.0f, 19.0f, BorderRadius.all(3.0f), Colors.WHITE.withAlpha(alpha));
        }
        boolean invis = this.isInvisibleTarget();
        String numberText = invis ? "?" : (healthNum == 1000.0f ? "?" : TextUtility.formatNumber(this.number.getValue()).replace(",", "."));
        String displayName = invis ? "(\u0438\u043d\u0432\u0438\u0437)" : this.target.method_5477().getString();
        context.drawFadeoutText(regular7, displayName, this.x + 30.0f + 8.0f * this.copy.getValue(), this.y + 3.0f + 6.0f * this.content.getValue(), Colors.getTextColor().withAlpha(alpha), 0.7f, 1.0f, this.width - 40.0f - 8.0f * this.copy.getValue() - semibold6.width(numberText));
        RenderUtility.rotate(context.method_51448(), this.x + 28.0f + 5.0f * this.copy.getValue(), this.y + 6.0f + 6.0f * this.content.getValue(), 90.0f * this.success.getValue());
        context.drawTexture(Rockstar.id("icons/hud/copy.png"), this.x + 25.0f + 5.0f * this.copy.getValue(), this.y + 3.0f + 6.0f * this.content.getValue(), 6.0f, 6.0f, Colors.getTextColor().withAlpha(alpha * this.copy.getValue() * (1.0f - this.success.getValue())));
        RenderUtility.end(context.method_51448());
        RenderUtility.rotate(context.method_51448(), this.x + 28.0f + 5.0f * this.copy.getValue(), this.y + 6.0f + 6.0f * this.content.getValue(), -90.0f + 90.0f * this.success.getValue());
        context.drawTexture(Rockstar.id("icons/check.png"), this.x + 25.0f + 5.0f * this.copy.getValue(), this.y + 3.0f + 6.0f * this.content.getValue(), 6.0f, 6.0f, Colors.GREEN.withAlpha(alpha * this.copy.getValue() * this.success.getValue()));
        RenderUtility.end(context.method_51448());
        context.drawRightText(semibold6, numberText, this.x + this.width - 7.0f, this.y + 4.0f + 6.0f * this.content.getValue(), this.hpColor.getColor().withAlpha(alpha));
        context.drawRoundedRect(this.x + 30.0f, this.y + this.height - 6.0f - 6.0f * this.content.getValue(), 65.0f, 3.0f, BorderRadius.all(0.7f), Colors.getAdditionalColor().withAlpha(alpha * (1.0f - 0.7f * Interface.glass())));
        context.drawRoundedRect(this.x + 30.0f, this.y + this.height - 6.0f - 6.0f * this.content.getValue(), 65.0f * Math.clamp((float)this.health.getValue(), (float)0.0f, (float)1.0f), 3.0f, BorderRadius.all(0.7f), this.hpColor.getColor().withAlpha(alpha));
        context.drawRoundedRect(this.x + 95.0f - 65.0f * Math.clamp((float)this.golden.getValue(), (float)0.0f, (float)1.0f), this.y + this.height - 6.0f - 6.0f * this.content.getValue(), 65.0f * Math.clamp((float)this.golden.getValue(), (float)0.0f, (float)1.0f), 3.0f, BorderRadius.all(0.7f), new ColorRGBA(255.0f, 220.0f, 81.0f, alpha));
        ScissorUtility.pop();
    }

    private class_1309 getTarget() {
        class_1297 target1 = Rockstar.getInstance().getTargetManager().getCurrentTarget();
        if (target1 instanceof class_1309) {
            class_1309 living = (class_1309)target1;
            return living;
        }
        class_1297 entity = TargetHud.mc.field_1692;
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            return living;
        }
        if (TargetHud.mc.field_1755 instanceof class_408) {
            return TargetHud.mc.field_1724;
        }
        return null;
    }

    @Override
    public void onMouseClicked(double mouseX, double mouseY, MouseButton button) {
        if (this.styleNew.isSelected() && GuiUtility.isHovered((double)(this.x + 30.0f), (double)(this.y + 3.0f + 6.0f * this.content.getValue()), 60.0, 6.0, mouseX, mouseY)) {
            TextUtility.copyText(TargetHud.mc.field_1724.method_5477().getString());
            this.copyTimer.reset();
            this.copied = true;
            return;
        }
        super.onMouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean show() {
        class_1309 currentTarget = this.getTarget();
        if (currentTarget != null) {
            return true;
        }
        if (this.lastTarget != null) {
            boolean isChatOpen = TargetHud.mc.field_1755 instanceof class_408;
            if (this.wasOpenedFromChat && !isChatOpen) {
                return false;
            }
            double distance = TargetHud.mc.field_1724.method_5739((class_1297)this.lastTarget);
            boolean tooFar = distance > 15.0;
            boolean timeExpired = this.targetLostTimer.finished(3000L);
            boolean targetDead = this.lastTarget.method_29504();
            return !tooFar && !timeExpired && !targetDead;
        }
        return false;
    }
}

