/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  com.mojang.blaze3d.systems.RenderSystem
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 *  net.minecraft.class_10142
 *  net.minecraft.class_10156
 *  net.minecraft.class_287
 *  net.minecraft.class_290
 *  net.minecraft.class_293$class_5596
 *  net.minecraft.class_2960
 */
package moscow.rockstar.ui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import moscow.rockstar.Rockstar;
import moscow.rockstar.framework.base.UIContext;
import moscow.rockstar.framework.objects.MouseButton;
import moscow.rockstar.systems.localization.Localizator;
import moscow.rockstar.systems.modules.modules.visuals.Interface;
import moscow.rockstar.systems.setting.Setting;
import moscow.rockstar.systems.setting.SettingsContainer;
import moscow.rockstar.ui.components.popup.Popup;
import moscow.rockstar.ui.hud.GridLine;
import moscow.rockstar.ui.hud.impl.island.DynamicIsland;
import moscow.rockstar.utility.animation.base.Animation;
import moscow.rockstar.utility.animation.base.Easing;
import moscow.rockstar.utility.colors.ColorRGBA;
import moscow.rockstar.utility.colors.Colors;
import moscow.rockstar.utility.game.cursor.CursorType;
import moscow.rockstar.utility.game.cursor.CursorUtility;
import moscow.rockstar.utility.gui.GuiUtility;
import moscow.rockstar.utility.interfaces.IMinecraft;
import moscow.rockstar.utility.interfaces.IScaledResolution;
import moscow.rockstar.utility.render.DrawUtility;
import moscow.rockstar.utility.render.RenderUtility;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public abstract class HudElement
implements SettingsContainer,
IMinecraft {
    protected float x;
    protected float y;
    protected float width;
    protected float height;
    protected final Animation animation = new Animation(300L, 0.0f, Easing.BAKEK_SIZE);
    protected final Animation visible = new Animation(300L, 0.0f, Easing.BAKEK_SIZE);
    protected final Animation selecting = new Animation(300L, 0.0f, Easing.BAKEK_SIZE);
    protected final Animation dragAnim = new Animation(300L, 0.0f, Easing.FIGMA_EASE_IN_OUT);
    private final Animation blurAnim = new Animation(300L, 0.0f, Easing.FIGMA_EASE_IN_OUT);
    private final Animation loadingAnim = new Animation(700L, 0.0f, Easing.SMOOTH_STEP);
    private final Animation widthAnim = new Animation(300L, 0.0f, Easing.BAKEK_SIZE);
    private final Animation heightAnim = new Animation(300L, 0.0f, Easing.BAKEK_SIZE);
    protected boolean showing;
    protected boolean select;
    private List<Setting> settings = new ArrayList<Setting>();
    private boolean dragging;
    private float dragX;
    private float dragY;
    private float startDragX;
    private float startDragY;
    protected final String name;
    protected final String icon;

    public HudElement(String name, String icon) {
        this.name = name;
        this.icon = icon;
    }

    public void render(UIContext context) {
        this.update(context);
        float anim = this.animation.getValue() * this.visible.getValue();
        if (anim == 0.0f) {
            return;
        }
        if (Interface.isHudGlowEnabled()) {
            this.renderGlow(context, this.x, this.y, this.width, this.height, Colors.ACCENT);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, anim));
        float scale = 0.5f + anim * 0.5f - 0.05f * this.selecting.getValue();
        RenderUtility.scale(context.method_51448(), this.x + this.width / 2.0f, this.y + this.height / 2.0f, scale);
        this.renderComponent(context);
        RenderUtility.end(context.method_51448());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected abstract void renderComponent(UIContext var1);

    public void update(UIContext context) {
        float oldWidth = this.widthAnim.getValue();
        this.widthAnim.update(this.width);
        float newWidth = this.widthAnim.getValue();
        float widthDelta = newWidth - oldWidth;
        boolean isLeftSide = this.x + this.width / 2.0f < IScaledResolution.sr.getScaledWidth() / 2.0f;
        boolean bl = isLeftSide;
        if (!isLeftSide) {
            this.x -= widthDelta;
        }
        if (widthDelta != 0.0f) {
            List<HudElement> allElements = Rockstar.getInstance().getHud().getElements();
            for (HudElement otherElement : allElements) {
                float distanceToOther;
                float f;
                if (otherElement == this || !otherElement.isShowing()) continue;
                float verticalOverlap = Math.min(this.y + this.height, otherElement.y + otherElement.height) - Math.max(this.y, otherElement.y);
                if (f <= 0.0f) continue;
                if (isLeftSide) {
                    float rightEdge = this.x + newWidth;
                    distanceToOther = otherElement.x - rightEdge;
                    if (!(distanceToOther >= -5.0f) || !(distanceToOther <= 25.0f)) continue;
                    otherElement.x += widthDelta;
                    otherElement.x = Math.max(0.0f, Math.min(otherElement.x, IScaledResolution.sr.getScaledWidth() - otherElement.width));
                    continue;
                }
                float leftEdge = this.x;
                distanceToOther = leftEdge - (otherElement.x + otherElement.width);
                if (!(distanceToOther >= -5.0f) || !(distanceToOther <= 25.0f)) continue;
                otherElement.x -= widthDelta;
                otherElement.x = Math.max(0.0f, Math.min(otherElement.x, IScaledResolution.sr.getScaledWidth() - otherElement.width));
            }
        }
        this.width = newWidth;
        this.dragAnim.update(this.dragging);
        this.animation.setEasing(this.showing ? Easing.BAKEK : Easing.BAKEK_BACK);
        this.animation.update(this.showing);
        this.visible.setEasing(this.show() ? Easing.BAKEK : Easing.BAKEK_BACK);
        this.visible.update(this.show());
        this.selecting.update(this.select);
        this.blurAnim.update(this.animation.getValue() >= 0.6f);
        if (this.dragging) {
            this.x = Math.clamp((float)((float)context.getMouseX() - this.dragX), (float)0.0f, (float)(IScaledResolution.sr.getScaledWidth() - this.width));
            this.y = Math.clamp((float)((float)context.getMouseY() - this.dragY), (float)0.0f, (float)(IScaledResolution.sr.getScaledHeight() - this.height));
            if (!(this instanceof DynamicIsland)) {
                for (GridLine line : Rockstar.getInstance().getHud().getGrid().getLines()) {
                    if (line.getType() == GridLine.Type.VERTICAL) {
                        this.x = this.snapToLine(line, this.x, List.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(this.width), (Object)Float.valueOf(this.width / 2.0f)), List.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(-this.width), (Object)Float.valueOf(-this.width / 2.0f)));
                        continue;
                    }
                    this.y = this.snapToLine(line, this.y, List.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(this.height)), List.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(-this.height)));
                }
            }
        }
        if (this.isHovered(context) && this.animation.getValue() >= 1.0f) {
            CursorUtility.set(CursorType.HAND);
        }
    }

    public void onMouseClicked(double mouseX, double mouseY, MouseButton button) {
        if (this.isHovered(mouseX, mouseY) && this.showing) {
            if (button == MouseButton.LEFT) {
                this.dragging = true;
                this.dragX = (float)(mouseX - (double)this.x);
                this.dragY = (float)(mouseY - (double)this.y);
                this.startDragX = this.x;
                this.startDragY = this.y;
            } else if (button == MouseButton.RIGHT) {
                this.select = true;
                this.loadingAnim.setValue(0.0f);
                Popup popup = new Popup((float)mouseX, (float)mouseY, 110.0f, 6.0f).title(Localizator.translate(this.settings.isEmpty() ? "actions" : "settings")).separator();
                for (Setting setting : this.settings) {
                    popup.setting(setting);
                }
                popup.button(Localizator.translate("remove"), "icons/hud/trash.png", popup1 -> {
                    this.showing = false;
                    popup1.setShowing(false);
                    Rockstar.getInstance().getFileManager().writeFile("client");
                }).onClose(() -> {
                    this.select = false;
                });
                Rockstar.getInstance().getHud().getPopups().add(popup);
            }
        }
    }

    public void onMouseReleased(double mouseX, double mouseY, MouseButton button) {
        if (this.dragging && button == MouseButton.LEFT) {
            this.dragging = false;
            if (this.x != this.startDragX || this.y != this.startDragY) {
                Rockstar.getInstance().getHud().getHistoryManager().registerMove(this, this.startDragX, this.startDragY, this.x, this.y);
            }
            Rockstar.getInstance().getFileManager().writeFile("client");
        }
    }

    private float snapToLine(GridLine line, float pos, List<Float> offsets, List<Float> adjustments) {
        for (int i = 0; i < offsets.size(); ++i) {
            float distance = Math.abs(pos + offsets.get(i).floatValue() - line.getPos());
            if (distance < 25.0f) {
                line.setActive(true);
            }
            if (!(distance < 5.0f)) continue;
            pos = line.getPos() + adjustments.get(i).floatValue();
        }
        return pos;
    }

    public boolean show() {
        return true;
    }

    public boolean isHovered(float mouseX, float mouseY) {
        return GuiUtility.isHovered((double)this.x, (double)this.y, (double)this.width, (double)this.height, mouseX, mouseY);
    }

    public boolean isHovered(double mouseX, double mouseY) {
        return GuiUtility.isHovered((double)this.x, (double)this.y, (double)this.width, (double)this.height, mouseX, mouseY);
    }

    public boolean isHovered(UIContext context) {
        return this.isHovered(context.getMouseX(), context.getMouseY());
    }

    public void pos(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public Animation getVisible() {
        return this.visible;
    }

    public Animation getSelecting() {
        return this.selecting;
    }

    public Animation getDragAnim() {
        return this.dragAnim;
    }

    public Animation getBlurAnim() {
        return this.blurAnim;
    }

    public Animation getLoadingAnim() {
        return this.loadingAnim;
    }

    public Animation getWidthAnim() {
        return this.widthAnim;
    }

    public Animation getHeightAnim() {
        return this.heightAnim;
    }

    public boolean isShowing() {
        return this.showing;
    }

    public boolean isSelect() {
        return this.select;
    }

    @Override
    public List<Setting> getSettings() {
        return this.settings;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public float getDragX() {
        return this.dragX;
    }

    public float getDragY() {
        return this.dragY;
    }

    public float getStartDragX() {
        return this.startDragX;
    }

    public float getStartDragY() {
        return this.startDragY;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setShowing(boolean showing) {
        this.showing = showing;
    }

    public void setSelect(boolean select) {
        this.select = select;
    }

    public void setSettings(List<Setting> settings) {
        this.settings = settings;
    }

    protected void renderGlow(UIContext context, float x, float y, float width, float height, ColorRGBA color) {
        if (!Interface.isHudGlowEnabled()) {
            return;
        }
        float intensity = Interface.getGlowIntensity();
        class_2960 bloomTexture = Rockstar.id("textures/bloom.png");
        RenderSystem.setShaderTexture((int)0, (class_2960)bloomTexture);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_287 buffer = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        float edgeGlowSize = Math.min(width, height) * 0.3f;
        float cornerGlowSize = Math.min(width, height) * 0.4f;
        float edgeAlpha = 0.2f * intensity;
        float cornerAlpha = 0.15f * intensity;
        float sideAlpha = 0.12f * intensity;
        float topGlowHeight = edgeGlowSize;
        float topGlowY = y - topGlowHeight / 2.0f;
        DrawUtility.drawImage(context.method_51448(), buffer, (double)x, (double)topGlowY, 0.0, (double)width, (double)topGlowHeight, color.withAlpha(255.0f * edgeAlpha));
        float bottomGlowHeight = edgeGlowSize;
        float bottomGlowY = y + height - bottomGlowHeight / 2.0f;
        DrawUtility.drawImage(context.method_51448(), buffer, (double)x, (double)bottomGlowY, 0.0, (double)width, (double)bottomGlowHeight, color.withAlpha(255.0f * edgeAlpha));
        float leftGlowWidth = edgeGlowSize;
        float leftGlowX = x - leftGlowWidth / 2.0f;
        DrawUtility.drawImage(context.method_51448(), buffer, (double)leftGlowX, (double)y, 0.0, (double)leftGlowWidth, (double)height, color.withAlpha(255.0f * edgeAlpha));
        float rightGlowWidth = edgeGlowSize;
        float rightGlowX = x + width - rightGlowWidth / 2.0f;
        DrawUtility.drawImage(context.method_51448(), buffer, (double)rightGlowX, (double)y, 0.0, (double)rightGlowWidth, (double)height, color.withAlpha(255.0f * edgeAlpha));
        float cornerX1 = x - cornerGlowSize / 2.0f;
        float cornerY1 = y - cornerGlowSize / 2.0f;
        DrawUtility.drawImage(context.method_51448(), buffer, (double)cornerX1, (double)cornerY1, 0.0, (double)cornerGlowSize, (double)cornerGlowSize, color.withAlpha(255.0f * cornerAlpha));
        float cornerX2 = x + width - cornerGlowSize / 2.0f;
        float cornerY2 = y - cornerGlowSize / 2.0f;
        DrawUtility.drawImage(context.method_51448(), buffer, (double)cornerX2, (double)cornerY2, 0.0, (double)cornerGlowSize, (double)cornerGlowSize, color.withAlpha(255.0f * cornerAlpha));
        float cornerX3 = x - cornerGlowSize / 2.0f;
        float cornerY3 = y + height - cornerGlowSize / 2.0f;
        DrawUtility.drawImage(context.method_51448(), buffer, (double)cornerX3, (double)cornerY3, 0.0, (double)cornerGlowSize, (double)cornerGlowSize, color.withAlpha(255.0f * cornerAlpha));
        float cornerX4 = x + width - cornerGlowSize / 2.0f;
        float cornerY4 = y + height - cornerGlowSize / 2.0f;
        DrawUtility.drawImage(context.method_51448(), buffer, (double)cornerX4, (double)cornerY4, 0.0, (double)cornerGlowSize, (double)cornerGlowSize, color.withAlpha(255.0f * cornerAlpha));
        float topSoftGlowHeight = edgeGlowSize * 1.5f;
        float topSoftGlowY = y - topSoftGlowHeight / 2.0f;
        DrawUtility.drawImage(context.method_51448(), buffer, (double)x, (double)topSoftGlowY, 0.0, (double)width, (double)topSoftGlowHeight, color.withAlpha(255.0f * sideAlpha));
        float bottomSoftGlowHeight = edgeGlowSize * 1.5f;
        float bottomSoftGlowY = y + height - bottomSoftGlowHeight / 2.0f;
        DrawUtility.drawImage(context.method_51448(), buffer, (double)x, (double)bottomSoftGlowY, 0.0, (double)width, (double)bottomSoftGlowHeight, color.withAlpha(255.0f * sideAlpha));
        float leftSoftGlowWidth = edgeGlowSize * 1.5f;
        float leftSoftGlowX = x - leftSoftGlowWidth / 2.0f;
        DrawUtility.drawImage(context.method_51448(), buffer, (double)leftSoftGlowX, (double)y, 0.0, (double)leftSoftGlowWidth, (double)height, color.withAlpha(255.0f * sideAlpha));
        float rightSoftGlowWidth = edgeGlowSize * 1.5f;
        float rightSoftGlowX = x + width - rightSoftGlowWidth / 2.0f;
        DrawUtility.drawImage(context.method_51448(), buffer, (double)rightSoftGlowX, (double)y, 0.0, (double)rightSoftGlowWidth, (double)height, color.withAlpha(255.0f * sideAlpha));
        RenderUtility.buildBuffer(buffer);
        RenderSystem.disableBlend();
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public void setDragX(float dragX) {
        this.dragX = dragX;
    }

    public void setDragY(float dragY) {
        this.dragY = dragY;
    }

    public void setStartDragX(float startDragX) {
        this.startDragX = startDragX;
    }

    public void setStartDragY(float startDragY) {
        this.startDragY = startDragY;
    }
}

