/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  com.mojang.blaze3d.systems.RenderSystem
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 */
package moscow.rockstar.ui.components.popup.list;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.BiConsumer;
import moscow.rockstar.framework.base.UIContext;
import moscow.rockstar.framework.msdf.Font;
import moscow.rockstar.framework.msdf.Fonts;
import moscow.rockstar.framework.objects.BorderRadius;
import moscow.rockstar.framework.objects.MouseButton;
import moscow.rockstar.ui.components.popup.PopupComponent;
import moscow.rockstar.utility.animation.base.Animation;
import moscow.rockstar.utility.animation.base.Easing;
import moscow.rockstar.utility.colors.ColorRGBA;
import moscow.rockstar.utility.colors.Colors;
import moscow.rockstar.utility.game.cursor.CursorType;
import moscow.rockstar.utility.game.cursor.CursorUtility;
import moscow.rockstar.utility.gui.GuiUtility;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ColorSquare
extends PopupComponent {
    private final String text;
    private final ColorRGBA color;
    private final BiConsumer<Double, Double> onColorClick;
    private final Animation hoverAnimation = new Animation(300L, Easing.FIGMA_EASE_IN_OUT);

    public ColorSquare(String text, ColorRGBA color, BiConsumer<Double, Double> onColorClick) {
        this.text = text;
        this.color = color;
        this.onColorClick = onColorClick;
    }

    @Override
    protected void renderComponent(UIContext context) {
        Font nameFont = Fonts.REGULAR.getFont(8.0f);
        float nameLeftPadding = 8.0f;
        float nameHeight = nameFont.height();
        float squareSize = 10.0f;
        float squareX = this.x + this.width - nameLeftPadding - squareSize - 8.0f;
        float squareY = this.y + GuiUtility.getMiddleOfBox(squareSize, this.height) - squareSize / 2.0f;
        this.hoverAnimation.update(this.isHovered(context.getMouseX(), context.getMouseY()) ? 1.0f : 0.0f);
        if (this.isHovered(context.getMouseX(), context.getMouseY())) {
            CursorUtility.set(CursorType.HAND);
        }
        context.drawFadeoutText(nameFont, this.text, this.x + nameLeftPadding, this.y + GuiUtility.getMiddleOfBox(nameHeight, this.height), Colors.getTextColor().withAlpha(RenderSystem.getShaderColor()[3] * 255.0f * (0.75f + 0.25f * this.hoverAnimation.getValue())), 0.8f, 1.0f, this.width - 12.0f - squareSize - 16.0f);
        context.drawRoundedRect(squareX, squareY, squareSize, squareSize, BorderRadius.all(2.5f), Colors.getOutlineColor());
        context.drawRoundedRect(squareX + 0.5f, squareY + 0.5f, squareSize - 1.0f, squareSize - 1.0f, BorderRadius.all(2.0f), this.color);
    }

    @Override
    public void onMouseClicked(double mouseX, double mouseY, MouseButton button) {
        float squareSize = 10.0f;
        float nameLeftPadding = 8.0f;
        float squareX = this.x + this.width - nameLeftPadding - squareSize - 8.0f;
        float squareY = this.y + GuiUtility.getMiddleOfBox(squareSize, this.height) - squareSize / 2.0f;
        if (button == MouseButton.LEFT && GuiUtility.isHovered((double)squareX, (double)squareY, (double)squareSize, (double)squareSize, mouseX, mouseY) && this.onColorClick != null) {
            this.onColorClick.accept(mouseX, mouseY);
        }
        super.onMouseClicked(mouseX, mouseY, button);
    }

    @Override
    public float getHeight() {
        this.height = 19.0f;
        return 19.0f;
    }
}

