/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 *  net.minecraft.class_1297
 *  net.minecraft.class_1308
 *  net.minecraft.class_1309
 *  net.minecraft.class_1429
 *  net.minecraft.class_1531
 *  net.minecraft.class_1657
 *  net.minecraft.class_1799
 *  net.minecraft.class_8113$class_8122
 */
package moscow.rockstar.systems.target;

import java.util.Comparator;
import java.util.function.Function;
import moscow.rockstar.Rockstar;
import moscow.rockstar.systems.target.TargetComparators;
import moscow.rockstar.utility.game.server.ServerUtility;
import moscow.rockstar.utility.interfaces.IMinecraft;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_8113;

@Environment(value=EnvType.CLIENT)
public class TargetSettings
implements IMinecraft {
    private boolean targetPlayers = false;
    private boolean targetAnimals = false;
    private boolean targetMobs = false;
    private boolean targetInvisibles = false;
    private boolean targetNakedPlayers = false;
    private boolean targetFriends = false;
    private boolean targetArmorStands = false;
    private float requiredRange = -1.0f;
    private Comparator<class_1297> targetComparator = TargetComparators.DISTANCE;

    public boolean isEntityValid(class_1297 entity) {
        class_1309 living;
        if (TargetSettings.mc.field_1724 == null || TargetSettings.mc.field_1687 == null || entity == null) {
            return false;
        }
        if (!ServerUtility.isCM() || !this.targetPlayers || entity instanceof class_8113.class_8122) {
            // empty if block
        }
        if (!(entity instanceof class_1309) || entity == TargetSettings.mc.field_1724) {
            return false;
        }
        if (entity instanceof class_1309 && (living = (class_1309)entity).method_29504()) {
            return false;
        }
        if (!this.isWithinRange(entity)) {
            return false;
        }
        if (entity instanceof class_1531) {
            return this.targetArmorStands;
        }
        if (!this.targetInvisibles && entity.method_5767()) {
            return false;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            boolean isFriend = Rockstar.getInstance().getFriendManager().isFriend(player.method_5477().getString());
            if (!this.targetFriends && isFriend) {
                return false;
            }
            boolean isNaked = this.isPlayerNaked(player);
            if (this.targetPlayers || this.targetNakedPlayers) {
                if (this.targetPlayers && this.targetNakedPlayers) {
                    return true;
                }
                if (this.targetNakedPlayers) {
                    return isNaked;
                }
                return !isNaked;
            }
            return false;
        }
        if (entity instanceof class_1429) {
            return this.targetAnimals;
        }
        if (entity instanceof class_1308) {
            return this.targetMobs;
        }
        return false;
    }

    public boolean isWithinRange(class_1297 entity) {
        if (this.getRequiredRange() <= 0.0f) {
            return true;
        }
        return entity.method_5739((class_1297)TargetSettings.mc.field_1724) <= this.getRequiredRange();
    }

    private boolean isPlayerNaked(class_1657 player) {
        for (class_1799 armorStack : player.method_56674()) {
            if (armorStack == null || armorStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public boolean isTargetPlayers() {
        return this.targetPlayers;
    }

    public boolean isTargetAnimals() {
        return this.targetAnimals;
    }

    public boolean isTargetMobs() {
        return this.targetMobs;
    }

    public boolean isTargetInvisibles() {
        return this.targetInvisibles;
    }

    public boolean isTargetNakedPlayers() {
        return this.targetNakedPlayers;
    }

    public boolean isTargetFriends() {
        return this.targetFriends;
    }

    public boolean isTargetArmorStands() {
        return this.targetArmorStands;
    }

    public float getRequiredRange() {
        return this.requiredRange;
    }

    public Comparator<class_1297> getTargetComparator() {
        return this.targetComparator;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Builder {
        private final TargetSettings settings = new TargetSettings();

        public Builder targetPlayers(boolean targetPlayers) {
            this.settings.targetPlayers = targetPlayers;
            return this;
        }

        public Builder targetAnimals(boolean targetAnimals) {
            this.settings.targetAnimals = targetAnimals;
            return this;
        }

        public Builder targetMobs(boolean targetMobs) {
            this.settings.targetMobs = targetMobs;
            return this;
        }

        public Builder targetInvisibles(boolean targetInvisibles) {
            this.settings.targetInvisibles = targetInvisibles;
            return this;
        }

        public Builder targetNakedPlayers(boolean targetNakedPlayers) {
            this.settings.targetNakedPlayers = targetNakedPlayers;
            return this;
        }

        public Builder targetFriends(boolean targetFriends) {
            this.settings.targetFriends = targetFriends;
            return this;
        }

        public Builder targetArmorStands(boolean targetArmorStands) {
            this.settings.targetArmorStands = targetArmorStands;
            return this;
        }

        public Builder requiredRange(float range) {
            this.settings.requiredRange = range;
            return this;
        }

        public Builder sortBy(Comparator<class_1297> comparator) {
            this.settings.targetComparator = comparator;
            return this;
        }

        public Builder sortByValue(Function<class_1297, Double> valueExtractor) {
            this.settings.targetComparator = TargetComparators.byValue(valueExtractor);
            return this;
        }

        public Builder sortByValueReversed(Function<class_1297, Double> valueExtractor) {
            this.settings.targetComparator = TargetComparators.byValueReversed(valueExtractor);
            return this;
        }

        public TargetSettings build() {
            return this.settings;
        }
    }
}

