/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 */
package moscow.rockstar.systems.modules.impl;

import java.util.ArrayList;
import java.util.List;
import moscow.rockstar.Rockstar;
import moscow.rockstar.systems.localization.Language;
import moscow.rockstar.systems.localization.Localizator;
import moscow.rockstar.systems.modules.Module;
import moscow.rockstar.systems.modules.api.ModuleCategory;
import moscow.rockstar.systems.modules.api.ModuleInfo;
import moscow.rockstar.systems.modules.modules.other.Sounds;
import moscow.rockstar.systems.modules.modules.visuals.MenuModule;
import moscow.rockstar.systems.notifications.NotificationType;
import moscow.rockstar.systems.setting.Setting;
import moscow.rockstar.systems.setting.SettingsContainer;
import moscow.rockstar.systems.setting.settings.BooleanSetting;
import moscow.rockstar.utility.animation.base.Animation;
import moscow.rockstar.utility.animation.base.Easing;
import moscow.rockstar.utility.game.TextUtility;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class BaseModule
implements Module {
    private final ModuleInfo info = this.getClass().getAnnotation(ModuleInfo.class);
    private int key;
    private ModuleCategory category;
    private boolean enabled;
    private boolean hidden;
    private String name;
    private List<Setting> settings = new ArrayList<Setting>();
    private final Animation keybindsAnimation = new Animation(300L, 0.0f, Easing.FIGMA_EASE_IN_OUT);
    private final BooleanSetting hideFromMenu = new BooleanSetting((SettingsContainer)this, "modules.settings.hide", () -> !this.canBeHidden());

    public BaseModule() {
        this.name = this.info.name();
        this.category = this.info.category();
        this.key = this.info.key();
    }

    protected boolean canBeHidden() {
        String moduleName = this.getName();
        return moduleName.equals("Auto Swap") || moduleName.equals("Middle Click") || moduleName.equals("Shift Tap") || moduleName.equals("Arrows") || moduleName.equals("Custom HitBox") || moduleName.equals("Nametags") || moduleName.equals("Assist") || moduleName.equals("Auto Accept");
    }

    @Override
    public boolean isHiddenFromMenu() {
        return this.hideFromMenu.isEnabled();
    }

    public void resetHideFromMenu() {
        this.hideFromMenu.setEnabled(false);
    }

    @Override
    public void toggle() {
        this.setEnabled(!this.enabled, false);
    }

    @Override
    public void onEnable() {
    }

    @Override
    public void onDisable() {
    }

    @Override
    public void tick() {
    }

    @Override
    public void disable() {
        this.setEnabled(false, false);
    }

    @Override
    public void enable() {
        this.setEnabled(true, false);
    }

    @Override
    public void setEnabled(boolean newState, boolean silent) {
        if (this.enabled == newState) {
            return;
        }
        this.enabled = newState;
        if (!(this instanceof MenuModule) && Rockstar.getInstance().getModuleManager().getModule(Sounds.class).isEnabled() && !silent) {
            Rockstar.getInstance().getModuleManager().getModule(Sounds.class).playModuleSound(this.enabled);
        }
        if (this.enabled) {
            Rockstar.getInstance().getEventManager().subscribe(this);
            if (!silent) {
                Rockstar.getInstance().getNotificationManager().addNotification(NotificationType.SUCCESS, this.name.replace(" ", "") + " " + Localizator.translate("enabled") + (Localizator.getCurrentLanguage() == Language.RU_RU ? TextUtility.makeGender(this.name) : ""));
            }
            this.onEnable();
        } else {
            Rockstar.getInstance().getEventManager().unsubscribe(this);
            if (!silent) {
                Rockstar.getInstance().getNotificationManager().addNotification(NotificationType.ERROR, this.name.replace(" ", "") + " " + Localizator.translate("disabled") + (Localizator.getCurrentLanguage() == Language.RU_RU ? TextUtility.makeGender(this.name) : ""));
            }
            this.onDisable();
        }
    }

    public String getSettingName(String key) {
        return "modules.settings." + this.getName().toLowerCase().replace(" ", "_") + "." + key;
    }

    @Override
    public ModuleInfo getInfo() {
        return this.info;
    }

    @Override
    public int getKey() {
        return this.key;
    }

    @Override
    public ModuleCategory getCategory() {
        return this.category;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Setting> getSettings() {
        return this.settings;
    }

    @Override
    public Animation getKeybindsAnimation() {
        return this.keybindsAnimation;
    }

    @Override
    public void setKey(int key) {
        this.key = key;
    }

    public void setCategory(ModuleCategory category) {
        this.category = category;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSettings(List<Setting> settings) {
        this.settings = settings;
    }
}

