/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 *  net.minecraft.class_310
 */
package moscow.rockstar.systems.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import moscow.rockstar.Rockstar;
import moscow.rockstar.systems.event.EventListener;
import moscow.rockstar.systems.event.impl.player.ClientPlayerTickEvent;
import moscow.rockstar.systems.event.impl.render.HudRenderEvent;
import moscow.rockstar.systems.event.impl.window.KeyPressEvent;
import moscow.rockstar.systems.event.impl.window.MouseEvent;
import moscow.rockstar.systems.modules.Module;
import moscow.rockstar.systems.modules.exception.UnknownModuleException;
import moscow.rockstar.systems.modules.impl.BaseModule;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import ru.kotopushka.compiler.sdk.annotations.CompileBytecode;

@Environment(value=EnvType.CLIENT)
public class ModuleManager {
    private final List<Module> modules = new ArrayList<Module>();
    private final EventListener<ClientPlayerTickEvent> tickListener;
    private final EventListener<HudRenderEvent> moduleWidgetRenderer;
    private final EventListener<KeyPressEvent> onKeyPress = event -> {
        if (class_310.method_1551().field_1755 != null) {
            return;
        }
        for (Module module : this.getModules()) {
            if (module.getKey() != event.getKey() || module.getKey() == -1 || event.getAction() != 1) continue;
            module.toggle();
        }
    };
    private final EventListener<MouseEvent> onMouseButtonPress = event -> {
        if (class_310.method_1551().field_1755 != null) {
            return;
        }
        for (Module module : this.getModules()) {
            if (module.getKey() != event.getButton() || module.getKey() == -1 || event.getAction() != 1) continue;
            module.toggle();
        }
    };

    public ModuleManager(EventListener<ClientPlayerTickEvent> tickListener, EventListener<HudRenderEvent> moduleWidgetRenderer) {
        this.tickListener = tickListener;
        this.moduleWidgetRenderer = moduleWidgetRenderer;
        Rockstar.getInstance().getEventManager().subscribe(this);
    }

    @CompileBytecode
    public void registerModules() {
        ServiceLoader<BaseModule> loader = ServiceLoader.load(BaseModule.class);
        for (BaseModule module : loader) {
            try {
                this.register(module);
            }
            catch (Exception e) {
                Rockstar.LOGGER.error("Failed to load module via ServiceLoader: " + module.getClass().getName(), (Throwable)e);
            }
        }
    }

    @CompileBytecode
    public void enableModules() {
        for (Module module : this.modules) {
            if (!module.getInfo().enabledByDefault()) continue;
            module.enable();
        }
    }

    public void register(BaseModule module) {
        this.modules.add(module);
    }

    public <T extends Module> T getModule(String name) {
        return (T)this.modules.stream().filter(module -> module.getName().replace(" ", "").equalsIgnoreCase(name) || module.getName().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new UnknownModuleException(name));
    }

    public <T extends Module> T getModule(Class<T> clazz) {
        return (T)this.modules.stream().filter(module -> module.getClass().equals(clazz)).findFirst().orElseThrow(() -> new UnknownModuleException(clazz.getSimpleName()));
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public EventListener<ClientPlayerTickEvent> getTickListener() {
        return this.tickListener;
    }

    public EventListener<HudRenderEvent> getModuleWidgetRenderer() {
        return this.moduleWidgetRenderer;
    }

    public EventListener<KeyPressEvent> getOnKeyPress() {
        return this.onKeyPress;
    }

    public EventListener<MouseEvent> getOnMouseButtonPress() {
        return this.onMouseButtonPress;
    }
}

