/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 */
package moscow.rockstar.protection.runtime;

import moscow.rockstar.protection.runtime.IntegrityChecker;
import moscow.rockstar.protection.runtime.LicenseValidator;
import moscow.rockstar.protection.runtime.ModuleClassLoader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ProtectionInitializer {
    private static boolean initialized = false;
    private static ModuleClassLoader moduleClassLoader;

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        System.out.println("[ProtectionInitializer] Initializing module protection...");
        try {
            if (!LicenseValidator.validate()) {
                throw new SecurityException("License validation failed!");
            }
            IntegrityChecker.initialize();
            if (!IntegrityChecker.verifyAll()) {
                throw new SecurityException("Integrity check failed!");
            }
            ClassLoader parentLoader = ProtectionInitializer.class.getClassLoader();
            moduleClassLoader = new ModuleClassLoader(parentLoader);
            System.out.println("[ProtectionInitializer] Module protection initialized successfully");
            initialized = true;
        }
        catch (Exception e) {
            System.err.println("[ProtectionInitializer] CRITICAL: Failed to initialize protection!");
            e.printStackTrace();
        }
    }

    public static ModuleClassLoader getModuleClassLoader() {
        if (!initialized) {
            ProtectionInitializer.initialize();
        }
        return moduleClassLoader;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static Class<?> loadProtectedClass(String className) throws ClassNotFoundException {
        if (!initialized) {
            ProtectionInitializer.initialize();
        }
        if (moduleClassLoader == null) {
            throw new IllegalStateException("Module ClassLoader not initialized");
        }
        return moduleClassLoader.loadClass(className);
    }
}

