/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 */
package moscow.rockstar.protection.runtime;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import moscow.rockstar.protection.runtime.IntegrityChecker;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ModuleClassLoader
extends ClassLoader {
    private static final String MODULE_PACKAGE = "moscow.rockstar.systems.modules.";
    private static final String PROTECTED_MARKER = ".protected";
    private static final byte[] DECRYPTION_KEY = ModuleClassLoader.getKey();
    private final Map<String, Class<?>> loadedClasses = new HashMap();
    private final ClassLoader parent;

    public ModuleClassLoader(ClassLoader parent) {
        super(parent);
        this.parent = parent;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (!name.startsWith(MODULE_PACKAGE)) {
            return this.parent.loadClass(name);
        }
        if (this.loadedClasses.containsKey(name)) {
            return this.loadedClasses.get(name);
        }
        try {
            String resourcePath = name.replace('.', '/') + ".class.protected";
            byte[] encryptedBytes = this.loadResource(resourcePath);
            if (encryptedBytes == null) {
                return this.parent.loadClass(name);
            }
            byte[] classBytes = this.decryptClass(encryptedBytes);
            if (!IntegrityChecker.verifyClass(name, classBytes)) {
                throw new SecurityException("Integrity check failed for: " + name);
            }
            Class<?> clazz = this.defineClass(name, classBytes, 0, classBytes.length);
            this.loadedClasses.put(name, clazz);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Failed to load protected class: " + name, e);
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass != null) {
            return loadedClass;
        }
        if (!name.startsWith(MODULE_PACKAGE)) {
            try {
                ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
                if (contextLoader != null && contextLoader != this) {
                    return contextLoader.loadClass(name);
                }
            }
            catch (ClassNotFoundException contextLoader) {
                // empty catch block
            }
            return this.parent.loadClass(name);
        }
        try {
            return this.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return this.parent.loadClass(name);
        }
    }

    private byte[] loadResource(String path) {
        try {
            int len;
            InputStream is = this.getResourceAsStream(path);
            if (is == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            is.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    private byte[] decryptClass(byte[] encrypted) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(DECRYPTION_KEY, "AES");
        cipher.init(2, keySpec);
        return cipher.doFinal(encrypted);
    }

    private static byte[] getKey() {
        return new byte[]{42, 126, 21, -100, 79, -93, 109, -72, 113, 35, -27, 15, -108, 59, -57, 88, -95, 111, 45, -114, 69, -71, 23, -13, 92, -88, 52, -47, 105, -66, 7, -11};
    }
}

