/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 */
package moscow.rockstar.protection.runtime;

import java.io.InputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class IntegrityChecker {
    private static final Map<String, String> EXPECTED_HASHES = new HashMap<String, String>();
    private static boolean initialized = false;

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        try {
            InputStream is = IntegrityChecker.class.getClassLoader().getResourceAsStream("META-INF/module.integrity");
            if (is == null) {
                System.err.println("[IntegrityChecker] WARNING: Integrity manifest not found!");
                initialized = true;
                return;
            }
            Properties props = new Properties();
            props.load(is);
            is.close();
            for (String key : props.stringPropertyNames()) {
                EXPECTED_HASHES.put(key, props.getProperty(key));
            }
            System.out.println("[IntegrityChecker] Loaded " + EXPECTED_HASHES.size() + " integrity hashes");
            initialized = true;
        }
        catch (Exception e) {
            System.err.println("[IntegrityChecker] Failed to load integrity manifest: " + e.getMessage());
            initialized = true;
        }
    }

    public static boolean verifyClass(String className, byte[] classBytes) {
        if (!initialized) {
            IntegrityChecker.initialize();
        }
        if (EXPECTED_HASHES.isEmpty()) {
            return true;
        }
        String classPath = className.replace('.', '/') + ".class";
        String expectedHash = EXPECTED_HASHES.get(classPath);
        if (expectedHash == null) {
            return true;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(classBytes);
            String actualHash = IntegrityChecker.bytesToHex(hash);
            boolean valid = expectedHash.equals(actualHash);
            if (!valid) {
                System.err.println("[IntegrityChecker] INTEGRITY VIOLATION: " + className);
                System.err.println("  Expected: " + expectedHash);
                System.err.println("  Actual:   " + actualHash);
            }
            return valid;
        }
        catch (Exception e) {
            System.err.println("[IntegrityChecker] Failed to verify: " + className);
            return false;
        }
    }

    public static boolean verifyAll() {
        if (!initialized) {
            IntegrityChecker.initialize();
        }
        if (EXPECTED_HASHES.isEmpty()) {
            System.out.println("[IntegrityChecker] No protected classes to verify");
            return true;
        }
        System.out.println("[IntegrityChecker] Verifying " + EXPECTED_HASHES.size() + " protected classes...");
        return true;
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

