/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  net.fabricmc.api.EnvType
 *  net.fabricmc.api.Environment
 *  net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener
 *  net.fabricmc.fabric.api.resource.ResourceManagerHelper
 *  net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener
 *  net.minecraft.class_1043
 *  net.minecraft.class_1044
 *  net.minecraft.class_2960
 *  net.minecraft.class_3264
 *  net.minecraft.class_3300
 *  org.slf4j.Logger
 *  org.slf4j.LoggerFactory
 */
package moscow.rockstar;

import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import moscow.rockstar.framework.shader.GlProgram;
import moscow.rockstar.protection.runtime.ProtectionInitializer;
import moscow.rockstar.systems.commands.CommandRegistry;
import moscow.rockstar.systems.config.ConfigDropHandler;
import moscow.rockstar.systems.config.ConfigManager;
import moscow.rockstar.systems.discord.DiscordManager;
import moscow.rockstar.systems.event.EventIntegration;
import moscow.rockstar.systems.event.EventManager;
import moscow.rockstar.systems.event.handlers.ServerConnectionHandler;
import moscow.rockstar.systems.file.FileManager;
import moscow.rockstar.systems.friends.FriendManager;
import moscow.rockstar.systems.localization.Localizator;
import moscow.rockstar.systems.modules.ModuleManager;
import moscow.rockstar.systems.modules.constructions.swinganim.SwingManager;
import moscow.rockstar.systems.modules.constructions.swinganim.presets.SwingPresetManager;
import moscow.rockstar.systems.modules.listeners.ModuleTickListener;
import moscow.rockstar.systems.modules.listeners.ModuleWidgetRenderer;
import moscow.rockstar.systems.nametag.NametagColorManager;
import moscow.rockstar.systems.notifications.NotificationManager;
import moscow.rockstar.systems.poshalko.PoshalkoHandler;
import moscow.rockstar.systems.target.TargetManager;
import moscow.rockstar.systems.theme.ThemeManager;
import moscow.rockstar.systems.waypoints.WayPointsManager;
import moscow.rockstar.ui.hud.Hud;
import moscow.rockstar.ui.menu.MenuScreen;
import moscow.rockstar.utility.game.TitleBarHelper;
import moscow.rockstar.utility.game.WebUtility;
import moscow.rockstar.utility.game.server.TPSHandler;
import moscow.rockstar.utility.interfaces.IMinecraft;
import moscow.rockstar.utility.math.calculator.ChatListener;
import moscow.rockstar.utility.render.DrawUtility;
import moscow.rockstar.utility.rotations.RotationHandler;
import moscow.rockstar.utility.rotations.RotationUpdateListener;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.kotopushka.compiler.sdk.annotations.Compile;
import ru.kotopushka.compiler.sdk.annotations.CompileBytecode;
import ru.kotopushka.compiler.sdk.annotations.Initialization;

@Environment(value=EnvType.CLIENT)
public enum Rockstar implements IMinecraft
{
    INSTANCE;

    public static final String NAME = "Rockstar";
    public static final String BUILD_TYPE = "Beta";
    public static final String VERSION = "2.0";
    public static final String MOD_ID;
    public static final Logger LOGGER;
    private EventManager eventManager;
    private ThemeManager themeManager;
    private ModuleManager moduleManager;
    private CommandRegistry commandManager;
    private FriendManager friendManager;
    private NametagColorManager nametagColorManager;
    private DiscordManager discordManager;
    private RotationHandler rotationHandler;
    private TargetManager targetManager;
    private FileManager fileManager;
    private NotificationManager notificationManager;
    private ConfigManager configManager;
    private SwingManager swingManager;
    private TPSHandler tpsHandler;
    private Hud hud;
    private ServerConnectionHandler serverConnectionHandler;
    private PoshalkoHandler poshalkoHandler;
    private WayPointsManager wayPointsManager;
    private SwingPresetManager swingPresetManager;
    private MenuScreen menuScreen;
    private ChatListener chatListener;
    private boolean panic;
    private boolean initialized = false;

    @Compile
    @Initialization
    public void initialize() {
        if (this.initialized) {
            LOGGER.warn("Rockstar already initialized, skipping...");
            return;
        }
        this.initialized = true;
        LOGGER.info("Initializing {}...", (Object)NAME);
        try {
            ProtectionInitializer.initialize();
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize module protection", (Throwable)e);
        }
        this.wayPointsManager = new WayPointsManager();
        this.eventManager = new EventManager();
        this.friendManager = new FriendManager();
        this.nametagColorManager = new NametagColorManager();
        this.themeManager = new ThemeManager();
        this.discordManager = new DiscordManager();
        this.rotationHandler = new RotationHandler(new RotationUpdateListener());
        this.targetManager = new TargetManager();
        this.fileManager = new FileManager();
        this.moduleManager = new ModuleManager(new ModuleTickListener(), new ModuleWidgetRenderer());
        this.hud = new Hud();
        this.tpsHandler = new TPSHandler();
        this.notificationManager = new NotificationManager();
        this.fileManager.registerClientFiles();
        this.moduleManager.registerModules();
        this.moduleManager.enableModules();
        this.configManager = new ConfigManager();
        this.configManager.handle();
        this.commandManager = new CommandRegistry();
        this.commandManager.initCommands();
        this.swingManager = new SwingManager();
        this.swingPresetManager = new SwingPresetManager();
        this.swingPresetManager.handle();
        this.fileManager.loadClientFiles();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(this){

            public class_2960 getFabricId() {
                return Rockstar.id("after_shader_load");
            }

            public void method_14491(class_3300 manager) {
                GlProgram.loadAndSetupPrograms();
            }
        });
        DrawUtility.initializeShaders();
        Localizator.loadTranslations();
        this.chatListener = new ChatListener();
        this.serverConnectionHandler = new ServerConnectionHandler();
        this.poshalkoHandler = new PoshalkoHandler();
        String osName = System.getProperty("os.name");
        String pcName = System.getProperty("user.name");
        if (osName.toLowerCase().contains("windows") && !pcName.equals("sheluvparis")) {
            this.discordManager.connect();
        }
        ConfigDropHandler.init();
        TitleBarHelper.setDarkTitleBar();
        new EventIntegration();
        this.createAvatar();
        LOGGER.info("{} initialized", (Object)NAME);
    }

    public void shutdown() {
        LOGGER.info("Shutting down...");
        this.fileManager.saveClientFiles();
        if (!this.isPanic()) {
            this.configManager.getAutoSaveConfig().save();
        }
        if (!this.isPanic()) {
            this.swingPresetManager.getAutoSavePreset().save();
        }
        this.setPanic(false);
    }

    public static Rockstar getInstance() {
        return INSTANCE;
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)"rockstar", (String)path);
    }

    @CompileBytecode
    private void createAvatar() {
        try {
            BufferedImage bufferedImage = ImageIO.read(new URL("https://rockstar.pub/api/avatars/ConeTin.jpg?t=1754613855632"));
            if (bufferedImage == null) {
                return;
            }
            class_2960 id = Rockstar.id("temp/avatar");
            mc.method_1531().method_4616(id, (class_1044)new class_1043(WebUtility.bufferedImageToNativeImage(bufferedImage, true)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public ThemeManager getThemeManager() {
        return this.themeManager;
    }

    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    public CommandRegistry getCommandManager() {
        return this.commandManager;
    }

    public FriendManager getFriendManager() {
        return this.friendManager;
    }

    public NametagColorManager getNametagColorManager() {
        return this.nametagColorManager;
    }

    public DiscordManager getDiscordManager() {
        return this.discordManager;
    }

    public RotationHandler getRotationHandler() {
        return this.rotationHandler;
    }

    public TargetManager getTargetManager() {
        return this.targetManager;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public SwingManager getSwingManager() {
        return this.swingManager;
    }

    public TPSHandler getTpsHandler() {
        return this.tpsHandler;
    }

    public Hud getHud() {
        return this.hud;
    }

    public ServerConnectionHandler getServerConnectionHandler() {
        return this.serverConnectionHandler;
    }

    public PoshalkoHandler getPoshalkoHandler() {
        return this.poshalkoHandler;
    }

    public WayPointsManager getWayPointsManager() {
        return this.wayPointsManager;
    }

    public SwingPresetManager getSwingPresetManager() {
        return this.swingPresetManager;
    }

    public MenuScreen getMenuScreen() {
        return this.menuScreen;
    }

    public ChatListener getChatListener() {
        return this.chatListener;
    }

    public boolean isPanic() {
        return this.panic;
    }

    public void setMenuScreen(MenuScreen menuScreen) {
        this.menuScreen = menuScreen;
    }

    public void setPanic(boolean panic) {
        this.panic = panic;
    }

    static {
        MOD_ID = "rockstar";
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
    }
}

